/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.intellisense;

import ca.teamdman.sfml.manipulation.ManipulationResult;

public class MutableProgramString {
    private StringBuilder content;
    private int cursorPosition;
    private int selectionCursorPosition;

    public MutableProgramString(String content, int cursorPosition, int selectionCursorPosition) {
        this.content = new StringBuilder(content);
        this.cursorPosition = cursorPosition;
        this.selectionCursorPosition = selectionCursorPosition;
    }

    public int getWordBeginning() {
        int start;
        for (start = this.cursorPosition; start > 0 && !Character.isWhitespace(this.content.charAt(start - 1)); --start) {
        }
        return start;
    }

    public int getWordEnd() {
        int end;
        for (end = this.cursorPosition; end < this.content.length() && !Character.isWhitespace(this.content.charAt(end)); ++end) {
        }
        return end;
    }

    public String getWord() {
        return this.content.substring(this.getWordBeginning(), this.getWordEnd());
    }

    public MutableProgramString replaceWordAndMoveCursorsToEnd(String suggestion) {
        int start = this.getWordBeginning();
        int end = this.getWordEnd();
        this.content.replace(start, end, suggestion);
        this.cursorPosition = start + suggestion.length();
        this.selectionCursorPosition = start + suggestion.length();
        return this;
    }

    public MutableProgramString insertTextWithoutMovingCursors(String text) {
        this.content.insert(this.cursorPosition, text);
        return this;
    }

    public String getContent() {
        return this.content.toString();
    }

    public MutableProgramString setContent(StringBuilder content) {
        this.content = content;
        return this;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public int getSelectionCursorPosition() {
        return this.selectionCursorPosition;
    }

    public MutableProgramString offsetCursors(int offset) {
        this.cursorPosition += offset;
        this.selectionCursorPosition += offset;
        return this;
    }

    public int cursorInWord() {
        return this.cursorPosition - this.getWordBeginning();
    }

    public ManipulationResult intoResult() {
        return new ManipulationResult(this.getContent(), this.getCursorPosition(), this.getSelectionCursorPosition());
    }
}

