/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.WaterTankBlock;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.Stored;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class ManagerBlock
extends BaseEntityBlock
implements EntityBlock,
ICableBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;

    public ManagerBlock() {
        super(BlockBehaviour.Properties.of().destroyTime(2.0f).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<WaterTankBlock> codec() {
        throw new NotImplementedException("This isn't used until 1.20.5 apparently");
    }

    public void neighborChanged(BlockState state, Level level, @NotStored BlockPos pos, Block block, @NotStored BlockPos neighbourPos, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ManagerBlockEntity)) {
            return;
        }
        ManagerBlockEntity mgr = (ManagerBlockEntity)blockEntity;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        boolean isPowered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        Boolean debounce = (Boolean)state.getValue((Property)TRIGGERED);
        if (isPowered && !debounce.booleanValue()) {
            mgr.trackRedstonePulseUnprocessed();
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isPowered && debounce.booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public BlockEntity newBlockEntity(@Stored BlockPos pos, BlockState state) {
        return SFMBlockEntities.MANAGER_BLOCK_ENTITY.get().create(pos, state);
    }

    public InteractionResult use(BlockState state, Level level, @NotStored BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ManagerBlockEntity) {
            ManagerBlockEntity manager = (ManagerBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DiskItem.rebuildWarnings(manager);
                serverPlayer.openMenu((MenuProvider)manager, buf -> ManagerContainerMenu.encode(manager, buf));
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return null;
        }
        return ManagerBlock.createTickerHelper(type, SFMBlockEntities.MANAGER_BLOCK_ENTITY.get(), ManagerBlockEntity::serverTick);
    }

    public void onPlace(BlockState state, Level world, @NotStored BlockPos pos, BlockState oldState, boolean isMoving) {
        CableNetworkManager.onCablePlaced(world, pos);
    }

    public void onRemove(BlockState state, Level level, @Stored BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)container);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            CableNetworkManager.onCableRemoved(level, pos);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TRIGGERED});
    }
}

