/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMConfigTracker;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.diagnostics.SFMDiagnostics;
import ca.teamdman.sfm.common.handler.OpenContainerTracker;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationEntry;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.net.ClientboundManagerGuiUpdatePacket;
import ca.teamdman.sfm.common.net.ClientboundManagerLogLevelUpdatedPacket;
import ca.teamdman.sfm.common.net.ClientboundManagerLogsPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.program.IProgramHooks;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.timing.SFMEpochInstant;
import ca.teamdman.sfm.common.timing.SFMInstant;
import ca.teamdman.sfm.common.util.SFMContainerUtil;
import ca.teamdman.sfml.ast.Program;
import com.google.common.base.Joiner;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class ManagerBlockEntity
extends BaseContainerBlockEntity {
    public static final int TICK_TIME_HISTORY_SIZE = 20;
    public final TranslatableLogger logger;
    private final NonNullList<ItemStack> ITEMS = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final Duration[] tickTimes = new Duration[20];
    public IItemHandler invWrapper = new InvWrapper((Container)this);
    @Nullable
    private Program program = null;
    private int configRevision = -1;
    private int tick = 0;
    private int unprocessedRedstonePulses = 0;
    private boolean shouldRebuildProgram = false;
    private int tickIndex = 0;
    private int automationAvoidRebuildingWarningsCooldown = 0;
    @Nullable
    private List<IProgramHooks> programHooks = null;

    public ManagerBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(SFMBlockEntities.MANAGER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public ManagerBlockEntity(BlockEntityType<?> pType, BlockPos blockPos, BlockState blockState) {
        super(pType, blockPos, blockState);
        String loggerName = "sfm:manager@" + blockPos.toShortString() + "@" + Integer.toHexString(System.identityHashCode((Object)this));
        this.logger = new TranslatableLogger(loggerName);
    }

    public String toString() {
        return "ManagerBlockEntity{hasDisk=" + (this.getDisk() != null) + ", pos=" + String.valueOf(this.getBlockPos()) + ", level=" + String.valueOf(this.getLevel()) + "}";
    }

    public void addProgramHooks(IProgramHooks hooks) {
        if (this.programHooks == null) {
            this.programHooks = new ArrayList<IProgramHooks>();
        }
        this.programHooks.add(hooks);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ManagerBlockEntity manager) {
        try {
            Duration elapsed;
            SFMInstant start = SFMInstant.now();
            ++manager.tick;
            manager.decrementRebuildWarningsCooldown();
            if (manager.configRevision != SFMConfig.SERVER_CONFIG.getRevision()) {
                manager.shouldRebuildProgram = true;
            }
            if (manager.shouldRebuildProgram) {
                manager.rebuildProgramAndUpdateDisk();
                manager.shouldRebuildProgram = false;
            }
            if (manager.program == null) {
                return;
            }
            boolean didSomething = manager.program.tick(manager);
            if (!didSomething) {
                return;
            }
            manager.tickTimes[manager.tickIndex] = elapsed = start.elapsed();
            manager.tickIndex = (manager.tickIndex + 1) % manager.tickTimes.length;
            manager.logger.trace(x -> x.accept(LocalizationKeys.PROGRAM_TICK_TIME_MS.get(Float.valueOf((float)elapsed.toNanos() / 1000000.0f))));
            if (manager.programHooks != null) {
                for (IProgramHooks hook : manager.programHooks) {
                    hook.onProgramDidSomething(elapsed);
                }
            }
            manager.sendUpdatePacket();
            manager.logger.pruneSoWeDontEatAllTheRam();
            if (manager.logger.getLogLevel() == org.apache.logging.log4j.Level.TRACE || manager.logger.getLogLevel() == org.apache.logging.log4j.Level.DEBUG || manager.logger.getLogLevel() == org.apache.logging.log4j.Level.INFO) {
                org.apache.logging.log4j.Level newLogLevel = org.apache.logging.log4j.Level.OFF;
                manager.logger.info(x -> x.accept(LocalizationKeys.LOG_LEVEL_UPDATED.get(newLogLevel)));
                org.apache.logging.log4j.Level oldLogLevel = manager.logger.getLogLevel();
                manager.setLogLevel(newLogLevel);
                SFM.LOGGER.debug("SFM updated manager {} {} log level to {} after a single execution at {} level", (Object)manager.getBlockPos(), (Object)manager.getLevel(), (Object)newLogLevel, (Object)oldLogLevel);
            }
        }
        catch (Throwable t) {
            Path found = SFMConfigTracker.getPathForConfig(SFMConfig.SERVER_CONFIG_SPEC);
            String configPath = found != null ? found.toString() : "sfm-server.toml";
            String configValuePath = Joiner.on((String)".").join((Iterable)SFMConfig.SERVER_CONFIG.disableProgramExecution.getPath());
            SFM.LOGGER.fatal("SFM detected a problem while ticking a manager. You can set `{} = true` in {} to help recover your world.", (Object)configValuePath, (Object)configPath);
            throw t;
        }
    }

    public void fillCrashReportCategory(CrashReportCategory pReportCategory) {
        super.fillCrashReportCategory(pReportCategory);
        Path found = SFMConfigTracker.getPathForConfig(SFMConfig.SERVER_CONFIG_SPEC);
        String configPath = found != null ? found.toString() : "sfm-server.toml";
        String configValuePath = Joiner.on((String)".").join((Iterable)SFMConfig.SERVER_CONFIG.disableProgramExecution.getPath());
        pReportCategory.setDetail("SFM Reminder", (Object)("You can set `" + configValuePath + " = true` in " + configPath + " to help recover your world."));
        ItemStack disk = this.getDisk();
        if (disk != null && !disk.isEmpty()) {
            pReportCategory.setDetail("SFM Details", (Object)SFMDiagnostics.getDiagnosticsSummary(disk));
        }
    }

    public void setLogLevel(org.apache.logging.log4j.Level logLevelObj) {
        this.logger.setLogLevel(logLevelObj);
        this.sendUpdatePacket();
    }

    public int getTick() {
        return this.tick;
    }

    @Nullable
    public Program getProgram() {
        return this.program;
    }

    public void setProgram(String program) {
        ItemStack disk = this.getDisk();
        if (disk != null) {
            this.ensureRebuildWarnings();
            DiskItem.setProgram(disk, program.stripTrailing().stripIndent());
            this.rebuildProgramAndUpdateDisk();
            this.setChanged();
        }
    }

    public void trackRedstonePulseUnprocessed() {
        ++this.unprocessedRedstonePulses;
    }

    public void clearRedstonePulseQueue() {
        this.unprocessedRedstonePulses = 0;
    }

    public int getUnprocessedRedstonePulseCount() {
        return this.unprocessedRedstonePulses;
    }

    public State getState() {
        if (this.getDisk() == null) {
            return State.NO_DISK;
        }
        if (this.getProgramString() == null) {
            return State.NO_PROGRAM;
        }
        if (this.program == null) {
            return State.INVALID_PROGRAM;
        }
        return State.RUNNING;
    }

    @Nullable
    public String getProgramString() {
        ItemStack disk = this.getDisk();
        if (disk == null) {
            return null;
        }
        String program = DiskItem.getProgramString(disk);
        return program.isBlank() ? null : program;
    }

    public String getProgramStringOrEmptyIfNull() {
        String programString = this.getProgramString();
        return programString == null ? "" : programString;
    }

    public Set<String> getReferencedLabels() {
        if (this.program == null) {
            return Collections.emptySet();
        }
        return this.program.referencedLabels();
    }

    @Nullable
    public ItemStack getDisk() {
        ItemStack item = this.getItem(0);
        if (item.getItem() instanceof DiskItem) {
            return item;
        }
        return null;
    }

    public boolean shouldRebuildWarnings() {
        return this.automationAvoidRebuildingWarningsCooldown < 300;
    }

    public void ensureRebuildWarnings() {
        this.automationAvoidRebuildingWarningsCooldown = 0;
    }

    public void incrementRebuildWarningsCooldown() {
        this.automationAvoidRebuildingWarningsCooldown = Mth.clamp((int)(this.automationAvoidRebuildingWarningsCooldown + 100), (int)0, (int)500);
    }

    public void decrementRebuildWarningsCooldown() {
        this.automationAvoidRebuildingWarningsCooldown = Math.max(0, this.automationAvoidRebuildingWarningsCooldown - 1);
    }

    public void rebuildProgramAndUpdateDisk() {
        if (this.level != null && this.level.isClientSide()) {
            return;
        }
        ItemStack disk = this.getDisk();
        if (disk == null) {
            this.program = null;
        } else {
            this.incrementRebuildWarningsCooldown();
            this.program = DiskItem.compileAndUpdateErrorsAndWarnings(disk, this, this.shouldRebuildWarnings());
        }
        this.configRevision = SFMConfig.SERVER_CONFIG.getRevision();
        this.sendUpdatePacket();
    }

    public int getContainerSize() {
        return this.ITEMS.size();
    }

    public boolean isEmpty() {
        return this.ITEMS.isEmpty();
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= this.ITEMS.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.ITEMS.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack result = ContainerHelper.removeItem(this.ITEMS, (int)slot, (int)amount);
        if (slot == 0) {
            this.rebuildProgramAndUpdateDisk();
        }
        this.setChanged();
        return result;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack result = ContainerHelper.takeItem(this.ITEMS, (int)slot);
        if (slot == 0) {
            this.rebuildProgramAndUpdateDisk();
        }
        this.setChanged();
        return result;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.ITEMS.size()) {
            return;
        }
        this.ITEMS.set(slot, (Object)stack);
        if (slot == 0) {
            this.rebuildProgramAndUpdateDisk();
        }
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return stack.getItem() instanceof DiskItem;
    }

    public boolean stillValid(Player player) {
        return SFMContainerUtil.stillValid((BlockEntity)this, player);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.ITEMS);
        this.shouldRebuildProgram = true;
        if (this.level != null) {
            this.tick = this.level.random.nextInt();
        }
    }

    public void clearContent() {
        this.ITEMS.clear();
    }

    public void reset() {
        ItemStack disk = this.getDisk();
        if (disk != null) {
            LabelPositionHolder.clear(disk);
            disk.setTag(null);
            this.setItem(0, disk);
            this.setChanged();
        }
    }

    public Duration[] getTickTimes() {
        Duration[] result = new Duration[this.tickTimes.length];
        System.arraycopy(this.tickTimes, this.tickIndex, result, 0, this.tickTimes.length - this.tickIndex);
        System.arraycopy(this.tickTimes, 0, result, this.tickTimes.length - this.tickIndex, this.tickIndex);
        return result;
    }

    public void sendUpdatePacket() {
        ClientboundManagerGuiUpdatePacket managerUpdatePacket = new ClientboundManagerGuiUpdatePacket(-1, this.getProgramStringOrEmptyIfNull(), this.getState(), this.getTickTimes());
        OpenContainerTracker.getOpenManagerMenus(this.getBlockPos()).forEach(entry -> {
            ArrayDeque<TranslatableLogEvent> logsToSend;
            ManagerContainerMenu menu = (ManagerContainerMenu)((Object)((Object)entry.getValue()));
            SFMPackets.sendToPlayer(entry::getKey, (SFMPacket)managerUpdatePacket.cloneWithWindowId(menu.containerId));
            if (!menu.isLogScreenOpen) {
                return;
            }
            if (!menu.logLevel.equals(this.logger.getLogLevel().name())) {
                SFMPackets.sendToPlayer(entry::getKey, (SFMPacket)new ClientboundManagerLogLevelUpdatedPacket(menu.containerId, this.logger.getLogLevel().name()));
                menu.logLevel = this.logger.getLogLevel().name();
            }
            SFMEpochInstant hasSince = SFMEpochInstant.zero();
            if (!menu.logs.isEmpty()) {
                hasSince = menu.logs.getLast().instant();
            }
            if (!(logsToSend = this.logger.getLogsAfter(hasSince)).isEmpty()) {
                menu.logs.add(logsToSend.getLast());
                while (!logsToSend.isEmpty()) {
                    int remaining = logsToSend.size();
                    SFMPackets.sendToPlayer(entry::getKey, (SFMPacket)ClientboundManagerLogsPacket.drainToCreate(menu.containerId, logsToSend));
                    if (logsToSend.size() < remaining) continue;
                    throw new IllegalStateException("Failed to send logs, infinite loop detected");
                }
            }
        });
    }

    protected Component getDefaultName() {
        return LocalizationKeys.MANAGER_CONTAINER.getComponent();
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory inv) {
        return new ManagerContainerMenu(windowId, inv, this);
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.ITEMS);
    }

    public static enum State {
        NO_PROGRAM(ChatFormatting.RED, LocalizationKeys.MANAGER_GUI_STATE_NO_PROGRAM),
        NO_DISK(ChatFormatting.RED, LocalizationKeys.MANAGER_GUI_STATE_NO_DISK),
        RUNNING(ChatFormatting.GREEN, LocalizationKeys.MANAGER_GUI_STATE_RUNNING),
        INVALID_PROGRAM(ChatFormatting.DARK_RED, LocalizationKeys.MANAGER_GUI_STATE_INVALID_PROGRAM);

        public final ChatFormatting COLOR;
        public final LocalizationEntry LOC;

        private State(ChatFormatting color, LocalizationEntry loc) {
            this.COLOR = color;
            this.LOC = loc;
        }
    }
}

