/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DiskResetRecipe
extends CustomRecipe {
    public DiskResetRecipe(CraftingBookCategory pGroup) {
        super(pGroup);
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        int foundDisks = 0;
        for (int i = 0; i < pContainer.getContainerSize(); ++i) {
            ItemStack stack = pContainer.getItem(i);
            if (stack.getItem() instanceof DiskItem) {
                ++foundDisks;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return foundDisks > 0;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess registryAccess) {
        int foundDisks = 0;
        for (int i = 0; i < pContainer.getContainerSize(); ++i) {
            ItemStack stack = pContainer.getItem(i);
            if (stack.getItem() instanceof DiskItem) {
                ++foundDisks;
                continue;
            }
            if (stack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return foundDisks > 0 ? new ItemStack((ItemLike)SFMItems.DISK_ITEM.get(), foundDisks) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SFMRecipeSerializers.DISK_RESET.get();
    }
}

