/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.block.BufferBlock;
import ca.teamdman.sfm.common.blockentity.BufferBlockEntityContents;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.resourcetype.RegistryBackedResourceType;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import java.util.stream.Stream;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.transmitter.TransmissionType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class PigmentResourceType
extends RegistryBackedResourceType<PigmentStack, Pigment, IPigmentHandler> {
    public static final SFMBlockCapabilityKind<IPigmentHandler> CAP = new SFMBlockCapabilityKind(Capabilities.PIGMENT.block());

    public PigmentResourceType() {
        super(CAP);
    }

    @Override
    public IPigmentHandler createHandlerForBufferBlock(BufferBlockEntityContents contents) {
        return (ChemicalTankBuilder.BasicPigmentTank)ChemicalTankBuilder.PIGMENT.create(contents.tier.getLongScalarMaxStackSize(), extracting -> {
            boolean isValid;
            ResourceType<?, ?, ?> resourceType = SFMMekanismCompat.getResourceType(TransmissionType.PIGMENT);
            boolean bl = isValid = resourceType != null && contents.allowInsertion(resourceType);
            if (isValid) {
                contents.lastUsedResource = BufferBlock.ContainedResource.Chemical;
            }
            return isValid;
        }, null);
    }

    @Override
    public long getAmount(PigmentStack stack) {
        return stack.getAmount();
    }

    @Override
    public PigmentStack getStackInSlot(IPigmentHandler handler, int slot) {
        return (PigmentStack)handler.getChemicalInTank(slot);
    }

    @Override
    public PigmentStack extract(IPigmentHandler handler, int slot, long amount, boolean simulate) {
        return (PigmentStack)handler.extractChemical(slot, amount, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public int getSlots(IPigmentHandler handler) {
        return handler.getTanks();
    }

    @Override
    public long getMaxStackSize(PigmentStack stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxStackSizeForSlot(IPigmentHandler handler, int slot) {
        return handler.getTankCapacity(slot);
    }

    @Override
    public PigmentStack insert(IPigmentHandler handler, int slot, PigmentStack stack, boolean simulate) {
        return (PigmentStack)handler.insertChemical(slot, (ChemicalStack)stack, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public boolean isEmpty(PigmentStack stack) {
        return stack.isEmpty();
    }

    @Override
    public PigmentStack getEmptyStack() {
        return PigmentStack.EMPTY;
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof PigmentStack;
    }

    @Override
    public boolean matchesCapabilityHandler(Object o) {
        return o instanceof IPigmentHandler;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(PigmentStack pigmentStack) {
        return ((Pigment)pigmentStack.getType()).getTags().map(TagKey::location);
    }

    @Override
    public SFMRegistryWrapper<Pigment> getRegistry() {
        return new SFMRegistryWrapper<Pigment>(MekanismAPI.PIGMENT_REGISTRY);
    }

    @Override
    public Pigment getItem(PigmentStack stack) {
        return (Pigment)stack.getType();
    }

    @Override
    public PigmentStack copy(PigmentStack stack) {
        return stack.copy();
    }

    @Override
    protected PigmentStack setCount(PigmentStack stack, long amount) {
        stack.setAmount(amount);
        return stack;
    }
}

