/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.timing;

import java.time.Duration;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.jetbrains.annotations.NotNull;

public record SFMEpochInstant(Instant instant) implements Comparable<SFMEpochInstant>
{
    public static SFMEpochInstant zero() {
        return new SFMEpochInstant((Instant)new MutableInstant());
    }

    @Override
    public int compareTo(@NotNull SFMEpochInstant o) {
        long millisDiff = this.instant.getEpochMillisecond() - o.instant.getEpochMillisecond();
        if (millisDiff != 0L) {
            return Long.signum(millisDiff);
        }
        return Integer.compare(this.instant.getNanoOfMillisecond(), o.instant.getNanoOfMillisecond());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.instant.getEpochMillisecond());
        buf.writeInt(this.instant.getNanoOfMillisecond());
    }

    public static SFMEpochInstant read(FriendlyByteBuf buf) {
        long epochMillisecond = buf.readLong();
        int epochNano = buf.readInt();
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(epochMillisecond, epochNano);
        return new SFMEpochInstant((Instant)instant);
    }

    public static SFMEpochInstant now() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(System.currentTimeMillis(), 0);
        return new SFMEpochInstant((Instant)instant);
    }

    public Duration elapsed() {
        SFMEpochInstant now = SFMEpochInstant.now();
        long millis = now.instant.getEpochMillisecond() - this.instant.getEpochMillisecond();
        long nanosOfMillisecond = now.instant.getNanoOfMillisecond() - this.instant.getNanoOfMillisecond();
        return Duration.ofNanos(millis * 1000000L + nanosOfMillisecond);
    }
}

