/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.network.FriendlyByteBuf;

public class CompressedBlockPosSet {
    private final ArrayList<Volume> boundingVolumes = new ArrayList();

    public static CompressedBlockPosSet from(Set<BlockPos> positions) {
        CompressedBlockPosSet rtn = new CompressedBlockPosSet();
        LongLinkedOpenHashSet remaining = new LongLinkedOpenHashSet(positions.size());
        for (BlockPos pos : positions) {
            remaining.add(pos.asLong());
        }
        while (!remaining.isEmpty()) {
            long start = remaining.iterator().nextLong();
            remaining.remove(start);
            Direction direction = Direction.NORTH;
            int extension = 0;
            for (Direction dir : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP}) {
                long offset = BlockPos.offset((long)start, (Direction)dir);
                if (!remaining.contains(offset)) continue;
                direction = dir;
                while (remaining.contains(offset)) {
                    remaining.remove(offset);
                    offset = BlockPos.offset((long)offset, (Direction)dir);
                    ++extension;
                }
                break;
            }
            rtn.boundingVolumes.add(new Volume(BlockPos.of((long)start), direction, extension));
        }
        return rtn;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.boundingVolumes.size());
        for (Volume volume : this.boundingVolumes) {
            volume.write(buf);
        }
    }

    public static CompressedBlockPosSet read(FriendlyByteBuf buf) {
        CompressedBlockPosSet rtn = new CompressedBlockPosSet();
        int count = buf.readVarInt();
        for (int i = 0; i < count; ++i) {
            rtn.boundingVolumes.add(Volume.read(buf));
        }
        return rtn;
    }

    public Set<BlockPos> into() {
        int capacity = 0;
        for (Volume volume : this.boundingVolumes) {
            capacity += volume.extension + 1;
        }
        HashSet<BlockPos> rtn = new HashSet<BlockPos>(capacity);
        for (Volume volume : this.boundingVolumes) {
            BlockPos start = volume.start;
            BlockPos end = start.relative(volume.direction, volume.extension);
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
                rtn.add(blockPos.immutable());
            }
        }
        return rtn;
    }

    public ByteArrayTag asTag() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.write(buf);
        return new ByteArrayTag(buf.array());
    }

    public static CompressedBlockPosSet from(ByteArrayTag tag) {
        return CompressedBlockPosSet.from(tag.getAsByteArray());
    }

    public static CompressedBlockPosSet from(byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        return CompressedBlockPosSet.read(buf);
    }

    public int hashCode() {
        return this.boundingVolumes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompressedBlockPosSet) {
            CompressedBlockPosSet set = (CompressedBlockPosSet)obj;
            return set.boundingVolumes.equals(this.boundingVolumes);
        }
        return false;
    }

    private record Volume(BlockPos start, Direction direction, int extension) {
        public void write(FriendlyByteBuf buf) {
            buf.writeBlockPos(this.start);
            buf.writeEnum((Enum)this.direction);
            buf.writeVarInt(this.extension);
        }

        public static Volume read(FriendlyByteBuf buf) {
            return new Volume(buf.readBlockPos(), (Direction)buf.readEnum(Direction.class), buf.readVarInt());
        }
    }
}

