/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.program_builder;

import ca.teamdman.langs.SFMLLexer;
import ca.teamdman.langs.SFMLParser;
import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import ca.teamdman.sfm.common.util.SFMTranslationUtils;
import ca.teamdman.sfml.ast.ASTBuilder;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.program_builder.ListErrorListener;
import ca.teamdman.sfml.program_builder.ProgramBuildResult;
import ca.teamdman.sfml.program_builder.ProgramMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jetbrains.annotations.Nullable;

public class ProgramBuilder {
    private static final WeakHashMap<String, ProgramBuildResult> cache = new WeakHashMap();
    private final String programString;
    private boolean useCache = true;

    public ProgramBuilder(@Nullable String programString) {
        if (programString == null) {
            programString = "";
        }
        this.programString = programString;
    }

    public static boolean isMutationAllowed(Program program) {
        return cache.values().stream().noneMatch(result -> result.program() == program);
    }

    public ProgramBuilder useCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public ProgramBuildResult build() {
        ProgramBuildResult cached;
        if (this.useCache && (cached = cache.get(this.programString)) != null) {
            if (cached.metadata().errors().isEmpty()) {
                return cached;
            }
            SFM.LOGGER.warn("Program cache hit, but the program build result contained errors. Will rebuild program.");
        }
        SFMLLexer lexer = new SFMLLexer((CharStream)CharStreams.fromString((String)this.programString));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SFMLParser parser = new SFMLParser((TokenStream)tokens);
        ASTBuilder builder = new ASTBuilder();
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        ArrayList<TranslatableContents> errors = new ArrayList<TranslatableContents>();
        ArrayList<String> buildErrors = new ArrayList<String>();
        ListErrorListener listener = new ListErrorListener(buildErrors);
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.addErrorListener((ANTLRErrorListener)listener);
        SFMLParser.ProgramContext context = parser.program();
        buildErrors.stream().map(xva$0 -> LocalizationKeys.PROGRAM_ERROR_LITERAL.get(xva$0)).forEach(errors::add);
        Program program = null;
        if (errors.isEmpty()) {
            try {
                program = builder.visitProgram(context);
                ProgramBuilder.checkResourceTypes(program, errors);
            }
            catch (AssertionError | IllegalArgumentException | ResourceLocationException e) {
                errors.add(LocalizationKeys.PROGRAM_ERROR_LITERAL.get(((Throwable)e).getMessage()));
            }
            catch (Throwable t) {
                errors.add(LocalizationKeys.PROGRAM_ERROR_COMPILE_FAILED.get());
                SFM.LOGGER.warn("Encountered unhandled error while compiling program\n```\n{}\n```", (Object)this.programString, (Object)t);
                String message = t.getMessage();
                if (message != null) {
                    errors.add(SFMTranslationUtils.getTranslatableContents(t.getClass().getSimpleName() + ": " + message));
                }
                errors.add(SFMTranslationUtils.getTranslatableContents(t.getClass().getSimpleName()));
            }
        }
        ProgramMetadata metadata = new ProgramMetadata(this.programString, lexer, tokens, parser, builder, errors);
        ProgramBuildResult programBuildResult = new ProgramBuildResult(program, metadata);
        if (this.useCache && buildErrors.isEmpty()) {
            cache.put(this.programString, programBuildResult);
        }
        return programBuildResult;
    }

    private static void checkResourceTypes(Program program, List<TranslatableContents> errors) {
        if (!SFMEnvironmentUtils.isGameLoaded()) {
            return;
        }
        List<? extends String> disallowedResourceTypes = SFMConfig.getOrDefault(SFMConfig.SERVER_CONFIG.disallowedResourceTypesForTransfer);
        for (ResourceIdentifier<?, ?, ?> referencedResource : program.referencedResources()) {
            try {
                ResourceType<?, ?, ?> resourceType = referencedResource.getResourceType();
                if (resourceType == null) {
                    errors.add(LocalizationKeys.PROGRAM_ERROR_UNKNOWN_RESOURCE_TYPE.get(referencedResource));
                    continue;
                }
                ResourceLocation resourceTypeId = Objects.requireNonNull(SFMResourceTypes.registry().getId(resourceType));
                if (!disallowedResourceTypes.contains(resourceTypeId.toString())) continue;
                errors.add(LocalizationKeys.PROGRAM_ERROR_DISALLOWED_RESOURCE_TYPE.get(referencedResource));
            }
            catch (ResourceLocationException e) {
                errors.add(LocalizationKeys.PROGRAM_ERROR_MALFORMED_RESOURCE_TYPE.get(referencedResource));
            }
        }
    }
}

