/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.screen.LogsScreen;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.client.screen.text_editor.SFMMultiLineTextRenderWidget;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditorUtils;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

class LogsScreenMultiLineEditBox
extends MultiLineEditBox {
    private final LogsScreen logsScreen;
    public SFMMultiLineTextRenderWidget textRenderWidget;
    public List<MutableComponent> styledTextContentLines = Collections.emptyList();
    private boolean scrollingEnabled = true;
    private boolean scrollbarDragActive;

    public LogsScreenMultiLineEditBox(LogsScreen logsScreen, Font pFont, int pX, int pY, int pWidth, int pHeight, Component pPlaceholder, Component pMessage) {
        super(pFont, pX, pY, pWidth, pHeight, pPlaceholder, pMessage);
        Rect2i textRenderWidgetArea = new Rect2i(SFMWidgetUtils.getX((AbstractWidget)this) + this.m_239244_(), SFMWidgetUtils.getY((AbstractWidget)this) + this.m_239244_(), this.f_93618_ - this.m_240012_(), this.f_93619_ - this.m_240012_());
        this.textRenderWidget = new SFMMultiLineTextRenderWidget(pFont, textRenderWidgetArea);
        this.textRenderWidget.setStyledTextContentLines(this.styledTextContentLines);
        this.textRenderWidget.setTextContent(this.m_239249_());
        this.logsScreen = logsScreen;
    }

    public void scrollToBottom() {
        this.m_240206_(this.m_239509_());
    }

    public int m_240211_() {
        int rtn = super.m_240211_();
        if (rtn == this.f_93619_) {
            return rtn - 1;
        }
        return rtn;
    }

    @MCVersionDependentBehaviour
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        try {
            boolean clickedScrollbar;
            if (pButton == 0) {
                this.scrollbarDragActive = false;
            }
            if (pButton == 0 && this.f_93624_ && this.m_239606_(pMouseX, pMouseY)) {
                if (this.styledTextContentLines.isEmpty()) {
                    return false;
                }
                this.m_93692_(true);
                boolean shiftDown = Screen.m_96638_();
                this.seekCursorFromPoint(pMouseX, pMouseY);
                if (!shiftDown) {
                    this.f_238540_.f_238550_ = this.f_238540_.f_238566_;
                }
                this.f_238540_.m_239950_(true);
                return true;
            }
            boolean bl = clickedScrollbar = pButton == 0 && this.f_93624_ && this.m_239656_() && pMouseX >= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.f_93618_) && pMouseX <= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.f_93618_ + 8) && pMouseY >= (double)SFMWidgetUtils.getY((AbstractWidget)this) && pMouseY < (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.f_93619_);
            if (clickedScrollbar) {
                this.scrollbarDragActive = true;
            }
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        catch (Exception e) {
            SFM.LOGGER.error("Error in mouseClicked handler", (Throwable)e);
            return false;
        }
    }

    public int m_239019_() {
        Objects.requireNonNull(this.f_238790_);
        return 9 * (this.styledTextContentLines.size() + 2);
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (button == 0) {
            this.f_238540_.m_239950_(false);
            this.scrollbarDragActive = false;
        }
        return super.m_6348_(mx, my, button);
    }

    public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
        if (this.scrollbarDragActive && super.m_7979_(mx, my, button, dx, dy)) {
            return true;
        }
        try {
            if (button == 0 && this.f_93624_ && this.m_239606_(mx, my)) {
                if (this.styledTextContentLines.isEmpty()) {
                    return false;
                }
                this.f_238540_.m_239950_(true);
                this.seekCursorFromPoint(mx, my);
                return true;
            }
        }
        catch (Exception e) {
            SFM.LOGGER.error("Error in mouseDragged handler", (Throwable)e);
            return false;
        }
        return false;
    }

    protected void m_240206_(double pScrollAmount) {
        if (!this.scrollingEnabled) {
            return;
        }
        super.m_240206_(pScrollAmount);
    }

    private void seekCursorFromPoint(double mx, double my) {
        int lineCount = this.styledTextContentLines.size();
        double innerX = mx - (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.m_239244_() + SFMTextEditorUtils.getLineNumberWidth(this.f_238790_, lineCount));
        double innerY = my - (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.m_239244_()) + this.m_239030_();
        int cursorPosition = this.textRenderWidget.pointToCharacterIndex(innerX, innerY);
        this.scrollingEnabled = false;
        this.f_238540_.m_239797_(Whence.ABSOLUTE, cursorPosition);
        this.scrollingEnabled = true;
    }

    protected int m_239509_() {
        return Math.max(1, super.m_239509_());
    }

    protected void m_239000_(PoseStack poseStack, int mx, int my, float partialTicks) {
        if (this.logsScreen.shouldRebuildText()) {
            this.logsScreen.rebuildText();
        }
        this.textRenderWidget.setCursorIndex(this.f_238540_.m_239456_());
        this.textRenderWidget.setFocused(this.m_93696_());
        this.textRenderWidget.setScrollAmount(this.m_239030_());
        this.textRenderWidget.setSelected(this.f_238540_.m_239982_());
        this.textRenderWidget.m_86412_(poseStack, mx, my, partialTicks);
    }
}

