/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen.text_editor;

import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditorUtils;
import ca.teamdman.sfm.common.util.SFMComponentUtils;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class SFMMultiLineTextRenderWidget
implements Renderable {
    private final Int2IntArrayMap lineStartIndices = new Int2IntArrayMap();
    private Font font;
    private List<? extends Component> styledTextContentLines = new ArrayList<Component>();
    private int frame = 0;
    private Rect2i area;
    private int cursorIndex = 0;
    private boolean focused = false;
    private double scrollAmount = 0.0;
    private MultilineTextField.StringView selected;
    private String textContent = "";

    public SFMMultiLineTextRenderWidget(Font font, Rect2i area) {
        this.font = font;
        this.area = area;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
        this.rebuildLineLookup();
    }

    public void setSelected(MultilineTextField.StringView selected) {
        this.selected = selected;
    }

    public void setScrollAmount(double scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public void setCursorIndex(int cursorIndex) {
        this.cursorIndex = cursorIndex;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public void setStyledTextContentLines(List<? extends Component> styledTextContentLines) {
        this.styledTextContentLines = styledTextContentLines;
    }

    public void m_86412_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        ++this.frame;
        if (this.styledTextContentLines.isEmpty()) {
            return;
        }
        boolean isCursorVisible = this.focused && this.frame / 20 % 2 == 0;
        Objects.requireNonNull(this.font);
        int lineHeight = Math.max(1, 9);
        int viewLineIndexStart = Mth.m_14045_((int)((int)Math.floor(this.scrollAmount / (double)lineHeight)), (int)0, (int)Math.max(0, this.styledTextContentLines.size() - 1));
        int numVisibleLines = Math.max(1, this.area.m_110091_() / lineHeight + 2);
        int viewLineIndexEnd = Math.min(this.styledTextContentLines.size(), viewLineIndexStart + numVisibleLines);
        int lineX = this.area.m_110085_() + SFMTextEditorUtils.getLineNumberWidth(this.font, this.styledTextContentLines.size());
        boolean isCursorAtEndOfLine = false;
        boolean drewCursorGlyph = false;
        int lineY = this.area.m_110086_() + viewLineIndexStart * lineHeight;
        int charCountAccum = this.getLineStartIndex(viewLineIndexStart);
        int cursorX = 0;
        int cursorY = 0;
        int selectionStart = this.selected.f_238590_();
        int selectionEnd = this.selected.f_238654_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ArrayList<int[]> highlightRects = new ArrayList<int[]>();
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        for (int line = viewLineIndexStart; line < viewLineIndexEnd; ++line) {
            boolean cursorOnThisLine;
            Component componentColoured = this.styledTextContentLines.get(line);
            String plainLine = componentColoured.getString();
            int lineLength = plainLine.length();
            boolean bl = cursorOnThisLine = isCursorVisible && this.cursorIndex >= charCountAccum && this.cursorIndex <= charCountAccum + lineLength;
            if (SFMTextEditorUtils.shouldShowLineNumbers()) {
                String lineNumber = String.valueOf(line + 1);
                SFMFontUtils.drawInBatch(lineNumber, this.font, (float)(lineX - 2 - this.font.m_92895_(lineNumber)), (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
            }
            if (cursorOnThisLine) {
                isCursorAtEndOfLine = this.cursorIndex == charCountAccum + lineLength;
                cursorY = lineY;
                int relativeCursorIndex = this.cursorIndex - charCountAccum;
                int drawnWidthBeforeCursor = this.font.m_92895_(plainLine.substring(0, relativeCursorIndex));
                cursorX = lineX + drawnWidthBeforeCursor;
                SFMFontUtils.drawInBatch((Component)SFMComponentUtils.substring(componentColoured, 0, relativeCursorIndex), this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                SFMFontUtils.drawInBatch((Component)SFMComponentUtils.substring(componentColoured, relativeCursorIndex, lineLength), this.font, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                drewCursorGlyph = true;
            } else {
                SFMFontUtils.drawInBatch(componentColoured, this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
            }
            if (selectionStart <= charCountAccum + lineLength && selectionEnd > charCountAccum) {
                int lineSelectionStart = Math.max(selectionStart - charCountAccum, 0);
                int lineSelectionEnd = Math.min(selectionEnd - charCountAccum, lineLength);
                int highlightStartX = this.font.m_92895_(plainLine.substring(0, lineSelectionStart));
                int highlightEndX = this.font.m_92895_(plainLine.substring(0, lineSelectionEnd));
                highlightRects.add(new int[]{lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight});
            }
            lineY += lineHeight;
            charCountAccum += lineLength + 1;
        }
        buffer.m_109911_();
        for (int[] r : highlightRects) {
            SFMScreenRenderUtils.renderHighlight(pPoseStack, r[0], r[1], r[2], r[3]);
        }
        if (drewCursorGlyph) {
            if (isCursorAtEndOfLine) {
                SFMFontUtils.draw(pPoseStack, this.font, "_", cursorX, cursorY, -1, true);
            } else {
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)cursorX, (int)(cursorY - 1), (int)(cursorX + 1), (int)(cursorY + 1 + 9), (int)-1);
            }
        }
    }

    public int pointToCharacterIndex(double innerX, double innerY) {
        int nextGlyphWidth;
        Objects.requireNonNull(this.font);
        int lineIndex = Mth.m_14045_((int)((int)Math.floor(innerY / (double)Math.max(1, 9))), (int)0, (int)Math.max(0, this.getLineCount() - 1));
        int lineStartIndex = this.getLineStartIndex(lineIndex);
        if (this.styledTextContentLines.isEmpty()) {
            return lineStartIndex;
        }
        int clampedLine = Mth.m_14045_((int)lineIndex, (int)0, (int)Math.max(0, this.styledTextContentLines.size() - 1));
        String plainLine = this.styledTextContentLines.get(clampedLine).getString();
        int clampedX = (int)Math.max(0.0, innerX);
        int cursorOffsetInLine = this.font.m_92834_(plainLine, clampedX).length();
        int widthBeforeCursor = this.font.m_92895_(plainLine.substring(0, cursorOffsetInLine));
        if (cursorOffsetInLine < plainLine.length() && (double)(clampedX - widthBeforeCursor) >= (double)(nextGlyphWidth = this.font.m_92895_(plainLine.substring(cursorOffsetInLine, cursorOffsetInLine + 1))) / 2.0) {
            cursorOffsetInLine = Math.min(plainLine.length(), cursorOffsetInLine + 1);
        }
        return Mth.m_14045_((int)(lineStartIndex + cursorOffsetInLine), (int)0, (int)this.getCharacterCount());
    }

    private int getLineCount() {
        return this.styledTextContentLines.size();
    }

    private int getCharacterCount() {
        return this.textContent.length();
    }

    private void rebuildLineLookup() {
        this.lineStartIndices.clear();
        this.lineStartIndices.put(0, 0);
        int line = 0;
        for (int i = 0; i < this.textContent.length(); ++i) {
            if (this.textContent.charAt(i) != '\n') continue;
            this.lineStartIndices.put(++line, i + 1);
        }
    }

    private int getLineStartIndex(int lineIndex) {
        if (this.lineStartIndices.isEmpty()) {
            return 0;
        }
        int clamped = Mth.m_14045_((int)lineIndex, (int)0, (int)Math.max(0, this.lineStartIndices.size() - 1));
        return this.lineStartIndices.get(clamped);
    }
}

