/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.client.registry.SFMTextEditors;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditorRegistration;
import ca.teamdman.sfm.client.text_editor.SFMTextEditorIntellisenseLevel;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFMClientTextEditorConfig {
    public final ForgeConfigSpec.BooleanValue showLineNumbers;
    public final ForgeConfigSpec.EnumValue<SFMTextEditorIntellisenseLevel> intellisenseLevel;
    public final ForgeConfigSpec.ConfigValue<String> preferredEditor;

    SFMClientTextEditorConfig(ForgeConfigSpec.Builder builder) {
        this.showLineNumbers = builder.define("showLineNumbers", false);
        this.intellisenseLevel = builder.defineEnum("intellisenseLevel", (Enum)SFMTextEditorIntellisenseLevel.OFF);
        this.preferredEditor = builder.define("preferredEditor", (Object)"sfm:v1");
    }

    @NotNull
    public static ISFMTextEditorRegistration getPreferredTextEditor() {
        @Nullable ResourceLocation id = SFMResourceLocation.tryParse((String)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.preferredEditor.get());
        if (id == null) {
            SFMTextEditors.V1.getId().ifPresent(defaultId -> SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.preferredEditor.set((Object)defaultId.m_135782_().toString()));
            return SFMTextEditors.V1.get();
        }
        return Objects.requireNonNullElse(SFMTextEditors.registry().get(id), (ISFMTextEditorRegistration)SFMTextEditors.V1.get());
    }
}

