/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.client.registry.SFMTextEditors;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditScreenV1;
import ca.teamdman.sfm.client.text_editor.SFMTextEditorIntellisenseLevel;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMClientTextEditorConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SFMTextEditorConfigScreen
extends Screen {
    private final SFMClientTextEditorConfig config;
    private final SFMTextEditScreenV1 parent;
    private final Runnable closeCallback;
    private Button lineNumbersOnButton;
    private Button lineNumbersOffButton;
    private Button intellisenseOffButton;
    private Button intellisenseBasicButton;
    private Button intellisenseAdvancedButton;
    private Button preferredEditorV1Button;
    private Button preferredEditorV2Button;
    private final boolean editorSelectorFeatureFlag = SFMEnvironmentUtils.isInIDE();

    public SFMTextEditorConfigScreen(SFMTextEditScreenV1 parent, SFMClientTextEditorConfig config, Runnable closeCallback) {
        super((Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_SCREEN_TITLE.getComponent());
        this.config = config;
        this.parent = parent;
        this.closeCallback = closeCallback;
    }

    public void m_7379_() {
        SFMScreenChangeHelpers.popScreen();
        this.closeCallback.run();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        int y = this.f_96544_ / 2 - 65;
        int x = this.f_96543_ / 2 - 150;
        graphics.m_280430_(this.f_96547_, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_LINE_NUMBERS.getComponent(), x, y, 0xFFFFFF);
        graphics.m_280430_(this.f_96547_, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE.getComponent(), x, y + 50, 0xFFFFFF);
        if (this.editorSelectorFeatureFlag) {
            graphics.m_280430_(this.f_96547_, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_PREFERRED_EDITOR.getComponent(), x, y + 100, 0xFFFFFF);
        }
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 100;
        int buttonHeight = 20;
        int x = this.f_96543_ / 2 - 3 * buttonWidth / 2 - 10;
        int y = this.f_96544_ / 2 - 50;
        int spacing = 50;
        int buttonSpacing = 10;
        this.lineNumbersOnButton = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y).setSize(buttonWidth, buttonHeight).setText(CommonComponents.f_130653_).setOnPress(button -> {
            this.config.showLineNumbers.set((Object)true);
            this.updateButtonStates();
        }).build();
        this.lineNumbersOffButton = new SFMButtonBuilder().setPosition(x, y).setSize(buttonWidth, buttonHeight).setText(CommonComponents.f_130654_).setOnPress(button -> {
            this.config.showLineNumbers.set((Object)false);
            this.updateButtonStates();
        }).build();
        this.m_142416_((GuiEventListener)this.lineNumbersOnButton);
        this.m_142416_((GuiEventListener)this.lineNumbersOffButton);
        this.intellisenseOffButton = new SFMButtonBuilder().setPosition(x, y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_OFF).setOnPress(button -> {
            this.config.intellisenseLevel.set((Object)SFMTextEditorIntellisenseLevel.OFF);
            this.updateButtonStates();
            this.parent.onIntellisensePreferenceChanged();
        }).build();
        this.intellisenseBasicButton = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_BASIC).setOnPress(button -> {
            this.config.intellisenseLevel.set((Object)SFMTextEditorIntellisenseLevel.BASIC);
            this.updateButtonStates();
            this.parent.onIntellisensePreferenceChanged();
        }).build();
        this.intellisenseAdvancedButton = new SFMButtonBuilder().setPosition(x + 2 * (buttonWidth + buttonSpacing), y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_ADVANCED).setOnPress(button -> {
            this.config.intellisenseLevel.set((Object)SFMTextEditorIntellisenseLevel.ADVANCED);
            this.updateButtonStates();
            this.parent.onIntellisensePreferenceChanged();
        }).build();
        this.m_142416_((GuiEventListener)this.intellisenseOffButton);
        this.m_142416_((GuiEventListener)this.intellisenseBasicButton);
        this.m_142416_((GuiEventListener)this.intellisenseAdvancedButton);
        this.preferredEditorV1Button = new SFMButtonBuilder().setPosition(x, y + 2 * spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_PREFERRED_EDITOR_V1).setOnPress(button -> {
            assert (SFMTextEditors.V1.getKey() != null);
            this.config.preferredEditor.set((Object)SFMTextEditors.V1.getKey().m_135782_().toString());
            this.updateButtonStates();
        }).build();
        this.preferredEditorV2Button = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y + 2 * spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_PREFERRED_EDITOR_V2).setOnPress(button -> {
            assert (SFMTextEditors.V2.getKey() != null);
            this.config.preferredEditor.set((Object)SFMTextEditors.V2.getKey().m_135782_().toString());
            this.updateButtonStates();
        }).build();
        if (this.editorSelectorFeatureFlag) {
            this.m_142416_((GuiEventListener)this.preferredEditorV1Button);
            this.m_142416_((GuiEventListener)this.preferredEditorV2Button);
        }
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 100, this.f_96544_ - 50).setSize(200, 20).setText(CommonComponents.f_130655_).setOnPress(button -> this.m_7379_()).build());
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this.lineNumbersOnButton.f_93623_ = (Boolean)this.config.showLineNumbers.get() == false;
        this.lineNumbersOffButton.f_93623_ = (Boolean)this.config.showLineNumbers.get();
        this.intellisenseOffButton.f_93623_ = this.config.intellisenseLevel.get() != SFMTextEditorIntellisenseLevel.OFF;
        this.intellisenseBasicButton.f_93623_ = this.config.intellisenseLevel.get() != SFMTextEditorIntellisenseLevel.BASIC;
        this.intellisenseAdvancedButton.f_93623_ = this.config.intellisenseLevel.get() != SFMTextEditorIntellisenseLevel.ADVANCED;
        String currentEditor = (String)this.config.preferredEditor.get();
        assert (SFMTextEditors.V1.getKey() != null);
        assert (SFMTextEditors.V2.getKey() != null);
        this.preferredEditorV1Button.f_93623_ = !currentEditor.equals(SFMTextEditors.V1.getKey().m_135782_().toString());
        this.preferredEditorV2Button.f_93623_ = !currentEditor.equals(SFMTextEditors.V2.getKey().m_135782_().toString());
    }
}

