/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen.text_editor;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.SFMTextEditorConfigScreen;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditScreenOpenContext;
import ca.teamdman.sfm.client.text_editor.SFMTextEditorIntellisenseLevel;
import ca.teamdman.sfm.client.widget.PickList;
import ca.teamdman.sfm.client.widget.PickListItem;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMDisplayUtils;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.intellisense.IntellisenseAction;
import ca.teamdman.sfml.intellisense.IntellisenseContext;
import ca.teamdman.sfml.intellisense.SFMLIntellisense;
import ca.teamdman.sfml.manipulation.ManipulationResult;
import ca.teamdman.sfml.manipulation.ProgramStringManipulationUtils;
import ca.teamdman.sfml.program_builder.ProgramBuildResult;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SFMTextEditScreenV1
extends Screen {
    private final ISFMTextEditScreenOpenContext openContext;
    protected MyMultiLineEditBox textarea;
    protected String lastProgram = "";
    protected List<MutableComponent> lastProgramWithSyntaxHighlighting = new ArrayList<MutableComponent>();
    protected PickList<IntellisenseAction> suggestedActions;

    public SFMTextEditScreenV1(ISFMTextEditScreenOpenContext openContext) {
        super((Component)LocalizationKeys.TEXT_EDIT_SCREEN_TITLE.getComponent());
        this.openContext = openContext;
    }

    public static MutableComponent substring(MutableComponent component, int start, int end) {
        MutableComponent rtn = Component.m_237119_();
        AtomicInteger seen = new AtomicInteger(0);
        component.m_7451_((style, content) -> {
            int contentEnd;
            int contentStart = Math.max(start - seen.get(), 0);
            if (contentStart < (contentEnd = Math.min(end - seen.get(), content.length()))) {
                rtn.m_7220_((Component)Component.m_237113_((String)content.substring(contentStart, contentEnd)).m_130948_(style));
            }
            seen.addAndGet(content.length());
            return Optional.empty();
        }, Style.f_131099_);
        return rtn;
    }

    public void scrollToTop() {
        this.textarea.scrollToTop();
    }

    public boolean m_7043_() {
        return false;
    }

    public void saveAndClose() {
        this.openContext.onSaveAndClose(this.textarea.m_239249_());
    }

    public void m_7379_() {
        this.openContext.onTryClose(this.textarea.m_239249_(), SFMScreenChangeHelpers::popScreen);
    }

    public void onIntellisensePreferenceChanged() {
        this.textarea.rebuildIntellisense();
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        return false;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (Screen.m_96637_() && pCodePoint == ' ') {
            return true;
        }
        if (!this.suggestedActions.isEmpty() && pCodePoint == '\\') {
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && Screen.m_96638_()) {
            this.saveAndClose();
            return true;
        }
        if (pKeyCode == 258) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            double scrollAmount = this.textarea.getScrollAmount();
            ManipulationResult result = Screen.m_96638_() ? ProgramStringManipulationUtils.deindent(content, cursor, selectionCursor) : ProgramStringManipulationUtils.indent(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.m_240206_(scrollAmount);
            return true;
        }
        if (pKeyCode == 92 && !this.suggestedActions.isEmpty()) {
            IntellisenseAction action = this.suggestedActions.getSelected();
            assert (action != null);
            ManipulationResult result = action.perform(new IntellisenseContext(ProgramBuilder.build(this.textarea.m_239249_()), this.textarea.getCursorPosition(), this.textarea.getSelectionCursorPosition(), this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get())));
            double scrollAmount = this.textarea.getScrollAmount();
            this.textarea.m_240159_(result.content());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.m_240206_(scrollAmount);
            return true;
        }
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        if (pKeyCode == 47 && Screen.m_96637_()) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            ManipulationResult result = ProgramStringManipulationUtils.toggleComments(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 32 && Screen.m_96637_()) {
            ProgramTokenContextActions.getContextAction(this.textarea.m_239249_(), this.textarea.getCursorPosition()).ifPresent(Runnable::run);
            this.textarea.rebuild(false);
            return true;
        }
        if (!(pKeyCode != 265 && pKeyCode != 264 || this.suggestedActions.getItems().isEmpty())) {
            if (pKeyCode == 265) {
                this.suggestedActions.selectPreviousWrapping();
            } else {
                this.suggestedActions.selectNextWrapping();
            }
            return true;
        }
        if (pKeyCode == 256 && !this.suggestedActions.isEmpty()) {
            this.suggestedActions.clear();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String prev = this.textarea.m_239249_();
        this.m_6575_(mc, x, y);
        super.m_6574_(mc, x, y);
        this.textarea.m_240159_(prev);
    }

    @MCVersionDependentBehaviour
    public void m_88315_(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mx, my, partialTicks);
    }

    private static boolean shouldShowLineNumbers() {
        return (Boolean)SFMConfig.getOrDefault(SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.showLineNumbers);
    }

    protected void renderTooltip(PoseStack pose, int mx, int my) {
        if (Minecraft.m_91087_().f_91080_ != this) {
            this.f_169369_.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(w -> w.m_93692_(false));
            return;
        }
        this.drawChildTooltips(pose, mx, my);
    }

    @MCVersionDependentBehaviour
    private void drawChildTooltips(PoseStack pose, int mx, int my) {
    }

    protected void m_7856_() {
        super.m_7856_();
        SFMScreenRenderUtils.enableKeyRepeating();
        this.textarea = (MyMultiLineEditBox)this.m_142416_((GuiEventListener)new MyMultiLineEditBox());
        Objects.requireNonNull(this.f_96547_);
        this.suggestedActions = (PickList)this.m_142416_((GuiEventListener)new PickList(this.f_96547_, 0, 0, 180, 9 * 6, (Component)LocalizationKeys.INTELLISENSE_PICK_LIST_GUI_TITLE.getComponent(), new ArrayList()));
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100 + 195).setSize(16, 20).setText((Component)Component.m_237113_((String)"#")).setOnPress(button -> {
            int cursorPos = this.textarea.getCursorPosition();
            int selectionCursorPos = this.textarea.getSelectionCursorPosition();
            SFMScreenChangeHelpers.setOrPushScreen(new SFMTextEditorConfigScreen(this, SFMConfig.CLIENT_TEXT_EDITOR_CONFIG, () -> {
                this.m_264313_((GuiEventListener)this.textarea);
                this.textarea.setCursorPosition(cursorPos);
                this.textarea.setSelectionCursorPosition(selectionCursorPos);
            }));
        }).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_CONFIG_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 - 150, this.f_96544_ / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.f_130655_).setOnPress(button -> this.saveAndClose()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 + 100, this.f_96544_ / 2 - 100 + 195).setSize(100, 20).setText(CommonComponents.f_130656_).setOnPress(button -> this.m_7379_()).build());
        this.textarea.m_240159_(this.openContext.initialValue());
        this.m_264313_((GuiEventListener)this.textarea);
    }

    protected class MyMultiLineEditBox
    extends MultiLineEditBox {
        public MyMultiLineEditBox() {
            super(SFMTextEditScreenV1.this.f_96547_, SFMTextEditScreenV1.this.f_96543_ / 2 - 200, SFMTextEditScreenV1.this.f_96544_ / 2 - 110, 400, 200, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)""));
            this.f_238540_.m_239919_(this::onValueOrCursorChanged);
            this.f_238540_.m_239257_(() -> this.onValueOrCursorChanged(this.f_238540_.m_239618_()));
        }

        public void scrollToTop() {
            this.m_240206_(0.0);
        }

        public int getCursorPosition() {
            return this.f_238540_.f_238566_;
        }

        public void setCursorPosition(int cursor) {
            this.f_238540_.m_239797_(Whence.ABSOLUTE, cursor);
        }

        public int getLineNumberWidth() {
            if (SFMTextEditScreenV1.shouldShowLineNumbers()) {
                return this.f_238790_.m_92895_("000");
            }
            return 0;
        }

        public int m_240211_() {
            int rtn = super.m_240211_();
            if (rtn == this.f_93619_) {
                return rtn - 1;
            }
            return rtn;
        }

        @MCVersionDependentBehaviour
        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            try {
                boolean rtn;
                if (pMouseX >= (double)(this.m_252754_() + 1) && pMouseX <= (double)(this.m_252754_() + this.f_93618_ - 1)) {
                    pMouseX -= (double)this.getLineNumberWidth();
                }
                if (!this.f_93624_) {
                    rtn = false;
                } else {
                    boolean flag1;
                    boolean flag = this.m_239606_(pMouseX, pMouseY);
                    boolean bl = flag1 = this.m_239656_() && pMouseX >= (double)(this.m_252754_() + this.f_93618_) && pMouseX <= (double)(this.m_252754_() + this.f_93618_ + 8) && pMouseY >= (double)this.m_252907_() && pMouseY < (double)(this.m_252907_() + this.f_93619_);
                    if (flag1 && pButton == 0) {
                        this.f_238779_ = true;
                        rtn = true;
                    } else {
                        rtn = false;
                    }
                }
                if (rtn) {
                    return true;
                }
                if (this.m_239606_(pMouseX, pMouseY) && pButton == 0) {
                    this.f_238540_.m_239950_(Screen.m_96638_());
                    this.m_239275_(pMouseX, pMouseY);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in SFMTextEditScreenV1.MyMultiLineEditBox.mouseClicked", (Throwable)e);
                return false;
            }
        }

        public int m_239019_() {
            Objects.requireNonNull(this.f_238790_);
            return 9 * (SFMTextEditScreenV1.this.lastProgramWithSyntaxHighlighting.size() + 2);
        }

        public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
            int thisX = SFMScreenRenderUtils.getX((AbstractWidget)this);
            if (mx >= (double)(thisX + 1) && mx <= (double)(thisX + this.f_93618_ - 1)) {
                mx -= (double)this.getLineNumberWidth();
            }
            return super.m_7979_(mx, my, button, dx, dy);
        }

        public int getSelectionCursorPosition() {
            return this.f_238540_.f_238550_;
        }

        public void setSelectionCursorPosition(int cursor) {
            this.f_238540_.f_238550_ = cursor;
        }

        public double getScrollAmount() {
            return this.m_239030_();
        }

        public void m_240206_(double d) {
            super.m_240206_(d);
        }

        protected int m_239509_() {
            return Math.max(1, super.m_239509_());
        }

        private void onValueOrCursorChanged(String programString) {
            int cursorPosition = this.getCursorPosition();
            ProgramBuildResult buildResult = ProgramBuilder.build(programString);
            IntellisenseContext intellisenseContext = new IntellisenseContext(buildResult, cursorPosition, this.getSelectionCursorPosition(), SFMTextEditScreenV1.this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get()));
            List<IntellisenseAction> suggestions = SFMLIntellisense.getSuggestions(intellisenseContext);
            SFMTextEditScreenV1.this.suggestedActions.setItems(suggestions);
            String cursorWord = buildResult.getWordAtCursorPosition(cursorPosition);
            SFMTextEditScreenV1.this.suggestedActions.setQuery((Component)Component.m_237113_((String)cursorWord));
            boolean shouldPrint = false;
            if (shouldPrint) {
                String cursorPositionDisplay = SFMDisplayUtils.getCursorPositionDisplay(programString, cursorPosition);
                String cursorTokenDisplay = SFMDisplayUtils.getCursorTokenDisplay(buildResult, cursorPosition);
                @Nullable Program program = buildResult.program();
                String tokenHierarchyDisplay = program == null ? "<INVALID PROGRAM>" : SFMDisplayUtils.getTokenHierarchyDisplay(program, cursorPosition);
                String suggestionsDisplay = SFMTextEditScreenV1.this.suggestedActions.getItems().stream().map(PickListItem::getComponent).map(Component::getString).collect(Collectors.joining(", "));
                SFM.LOGGER.info("PROGRAM OR CURSOR CHANGE! {}   {}   {}  |||  {} ||| {}", (Object)cursorPositionDisplay, (Object)cursorTokenDisplay, (Object)tokenHierarchyDisplay, (Object)cursorWord, (Object)suggestionsDisplay);
            }
        }

        private void rebuildIntellisense() {
            this.onValueOrCursorChanged(this.m_239249_());
        }

        private void rebuild(boolean showContextActionHints) {
            SFMTextEditScreenV1.this.lastProgram = this.f_238540_.m_239618_();
            SFMTextEditScreenV1.this.lastProgramWithSyntaxHighlighting = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(SFMTextEditScreenV1.this.lastProgram, showContextActionHints);
        }

        protected void m_239197_(GuiGraphics graphics, int mx, int my, float partialTicks) {
            Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
            if (!SFMTextEditScreenV1.this.lastProgram.equals(this.f_238540_.m_239618_())) {
                this.rebuild(Screen.m_96637_());
            }
            List<MutableComponent> lines = SFMTextEditScreenV1.this.lastProgramWithSyntaxHighlighting;
            boolean isCursorVisible = this.m_93696_() && this.f_238824_ / 6 % 2 == 0;
            boolean isCursorAtEndOfLine = false;
            int cursorIndex = this.f_238540_.m_239456_();
            int lineX = SFMScreenRenderUtils.getX((AbstractWidget)this) + this.m_239244_() + this.getLineNumberWidth();
            int lineY = SFMScreenRenderUtils.getY((AbstractWidget)this) + this.m_239244_();
            int charCount = 0;
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.f_238540_.m_239982_();
            int selectionStart = selectedRange.f_238590_();
            int selectionEnd = selectedRange.f_238654_();
            for (int line = 0; line < lines.size(); ++line) {
                MutableComponent componentColoured = lines.get(line);
                int lineLength = componentColoured.getString().length();
                Objects.requireNonNull(this.f_238790_);
                int lineHeight = 9;
                boolean cursorOnThisLine = isCursorVisible && cursorIndex >= charCount && cursorIndex <= charCount + lineLength;
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                if (SFMTextEditScreenV1.shouldShowLineNumbers()) {
                    String lineNumber = String.valueOf(line + 1);
                    SFMFontUtils.drawInBatch(lineNumber, this.f_238790_, (float)(lineX - 2 - this.f_238790_.m_92895_(lineNumber)), (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCount + lineLength;
                    cursorY = lineY;
                    cursorX = SFMFontUtils.drawInBatch((Component)SFMTextEditScreenV1.substring(componentColoured, 0, cursorIndex - charCount), this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer) - 1;
                    SFMTextEditScreenV1.this.suggestedActions.setXY(cursorX + 10, cursorY);
                    SFMFontUtils.drawInBatch((Component)SFMTextEditScreenV1.substring(componentColoured, cursorIndex - charCount, lineLength), this.f_238790_, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                } else {
                    SFMFontUtils.drawInBatch((Component)componentColoured, this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                buffer.m_109911_();
                if (selectionStart <= charCount + lineLength && selectionEnd > charCount) {
                    int lineSelectionStart = Math.max(selectionStart - charCount, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCount, lineLength);
                    int highlightStartX = this.f_238790_.m_92852_((FormattedText)SFMTextEditScreenV1.substring(componentColoured, 0, lineSelectionStart));
                    int highlightEndX = this.f_238790_.m_92852_((FormattedText)SFMTextEditScreenV1.substring(componentColoured, 0, lineSelectionEnd));
                    SFMScreenRenderUtils.renderHighlight(graphics, lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight);
                }
                lineY += lineHeight;
                charCount += lineLength + 1;
            }
            if (isCursorAtEndOfLine) {
                SFMFontUtils.draw(graphics, this.f_238790_, "_", cursorX, cursorY, -1, true);
            } else {
                graphics.m_280509_(cursorX, cursorY - 1, cursorX + 1, cursorY + 1 + 9, -1);
            }
        }
    }
}

