/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.client.ClientFacadeWarningHelper;
import ca.teamdman.sfm.client.ClientKeyHelpers;
import ca.teamdman.sfm.client.handler.NetworkToolKeyMappingHandler;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.facade.FacadeSpreadLogic;
import ca.teamdman.sfm.common.net.ServerboundFacadePacket;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.Stored;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class CableBlock
extends Block
implements ICableBlock,
IFacadableBlock {
    public CableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level world, @Stored BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (!(oldState.m_60734_() instanceof ICableBlock)) {
            CableNetworkManager.onCablePlaced(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, @Stored BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!(newState.m_60734_() instanceof ICableBlock)) {
            CableNetworkManager.onCableRemoved(level, pos);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, @Stored BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_21206_().m_41720_() == SFMItems.NETWORK_TOOL_ITEM.get()) {
            if (pLevel.m_5776_() && pHand == InteractionHand.MAIN_HAND) {
                ServerboundFacadePacket msg = new ServerboundFacadePacket(pHit, FacadeSpreadLogic.fromParts(Screen.m_96637_(), Screen.m_96639_()), pPlayer.m_21205_(), InteractionHand.MAIN_HAND);
                if (ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.TOGGLE_NETWORK_TOOL_OVERLAY_KEY)) {
                    NetworkToolKeyMappingHandler.setExternalDebounce();
                }
                ClientFacadeWarningHelper.sendFacadePacketFromClientWithConfirmationIfNecessary(msg);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public IFacadableBlock getNonFacadeBlock() {
        return (IFacadableBlock)SFMBlocks.CABLE_BLOCK.get();
    }

    @Override
    public IFacadableBlock getFacadeBlock() {
        return (IFacadableBlock)SFMBlocks.CABLE_FACADE_BLOCK.get();
    }

    @Override
    public BlockState getStateForPlacementByFacadePlan(LevelAccessor level, @NotStored BlockPos pos) {
        return this.m_49966_();
    }
}

