/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ClientboundContainerExportsInspectionResultsPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.registry.SFMCapabilityProviderMappers;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMASTUtils;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.RoundRobin;
import ca.teamdman.sfml.ast.With;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record ServerboundContainerExportsInspectionRequestPacket(int windowId, BlockPos pos) implements SFMPacket
{
    public static String buildInspectionResults(Level level, BlockPos pos) {
        BlockEntity be;
        StringBuilder sb = new StringBuilder();
        for (Direction direction : SFMDirections.DIRECTIONS_WITH_NULL) {
            sb.append("-- ").append(direction).append("\n");
            int len = sb.length();
            SFMResourceTypes.registry().getEntries().stream().map(entry -> ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((ResourceKey)entry.getKey(), (ResourceType)entry.getValue(), level, pos, direction)).filter(s -> !s.isBlank()).forEach(results -> sb.append((String)results).append("\n"));
            if (sb.length() == len) {
                sb.append("No exports found");
            }
            sb.append("\n");
        }
        if (SFMModCompat.isMekanismLoaded() && (be = level.m_7702_(pos)) != null) {
            sb.append(SFMMekanismCompat.gatherInspectionResults(be)).append("\n");
        }
        return sb.toString();
    }

    public static <STACK, ITEM, CAP> String buildInspectionResults(ResourceKey<ResourceType<STACK, ITEM, CAP>> resourceTypeResourceKey, ResourceType<STACK, ITEM, CAP> resourceType, Level level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity be;
        String result;
        StringBuilder sb = new StringBuilder();
        ICapabilityProvider prov = SFMCapabilityProviderMappers.discoverCapabilityProvider(level, pos);
        if (prov != null) {
            prov.getCapability(resourceType.CAPABILITY_KIND, direction).ifPresent(cap -> {
                int slots = resourceType.getSlots(cap);
                Int2ObjectArrayMap slotContents = new Int2ObjectArrayMap(slots);
                for (int slot2 = 0; slot2 < slots; ++slot2) {
                    Object stack2 = resourceType.getStackInSlot(cap, slot2);
                    if (resourceType.isEmpty(stack2)) continue;
                    slotContents.put(slot2, stack2);
                }
                if (!slotContents.isEmpty()) {
                    slotContents.forEach((slot, stack) -> {
                        InputStatement inputStatement = SFMASTUtils.getInputStatementForStack(resourceTypeResourceKey, resourceType, stack, "target", slot, false, direction);
                        sb.append(inputStatement.toStringPretty()).append("\n");
                    });
                    ArrayList resourceLimitList = new ArrayList();
                    slotContents.forEach((slot, stack) -> {
                        ResourceLocation stackId = resourceType.getRegistryKeyForStack(stack);
                        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey, stackId);
                        ResourceLimit resourceLimit = new ResourceLimit(new ResourceIdSet(List.of(resourceIdentifier)), Limit.MAX_QUANTITY_NO_RETENTION, With.ALWAYS_TRUE);
                        resourceLimitList.add(resourceLimit);
                    });
                    InputStatement inputStatement = new InputStatement(new LabelAccess(List.of(new Label("target")), new DirectionQualifier(direction == null ? EnumSet.noneOf(Direction.class) : EnumSet.of(direction)), NumberRangeSet.MAX_RANGE, RoundRobin.disabled()), new ResourceLimits(resourceLimitList.stream().distinct().toList(), ResourceIdSet.EMPTY), false);
                    sb.append(inputStatement.toStringPretty());
                }
            });
        }
        if (!(result = sb.toString()).isBlank() && (be = level.m_7702_(pos)) != null && direction == null && ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_()).m_135827_().equals("mekanism")) {
            return "-- " + LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_NULL_DIRECTION_WARNING.getStub() + "\n" + result;
        }
        return result;
    }

    public static class Daddy
    implements SFMPacketDaddy<ServerboundContainerExportsInspectionRequestPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundContainerExportsInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_130130_(msg.windowId());
            friendlyByteBuf.m_130064_(msg.pos());
        }

        @Override
        public ServerboundContainerExportsInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
            return new ServerboundContainerExportsInspectionRequestPacket(friendlyByteBuf.m_130242_(), friendlyByteBuf.m_130135_());
        }

        @Override
        public void handle(ServerboundContainerExportsInspectionRequestPacket msg, SFMPacketHandlingContext context) {
            context.handleServerboundContainerPacket(AbstractContainerMenu.class, BlockEntity.class, msg.pos, msg.windowId, (menu, blockEntity) -> {
                assert (blockEntity.m_58904_() != null);
                String payload = ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults(blockEntity.m_58904_(), blockEntity.m_58899_());
                ServerPlayer player = context.sender();
                SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundContainerExportsInspectionResultsPacket(msg.windowId, SFMPacketDaddy.truncate(payload, 20480)));
            });
        }

        @Override
        public Class<ServerboundContainerExportsInspectionRequestPacket> getPacketClass() {
            return ServerboundContainerExportsInspectionRequestPacket.class;
        }
    }
}

