/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.resourcetype.ScalarResourceType;
import java.util.stream.Stream;
import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class MekanismEnergyResourceType
extends ScalarResourceType<FloatingLong, IStrictEnergyHandler> {
    public static final Capability<IStrictEnergyHandler> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IStrictEnergyHandler>(){});

    public MekanismEnergyResourceType() {
        super(CAP, new ResourceLocation("mekanism", "energy"), FloatingLong.class);
    }

    @Override
    public long getAmount(FloatingLong amount) {
        return amount.longValue();
    }

    @Override
    public long getAmountDifference(FloatingLong stack1, FloatingLong stack2) {
        return stack1.subtract(stack2).longValue();
    }

    @Override
    public FloatingLong getStackInSlot(IStrictEnergyHandler storage, int slot) {
        return storage.getEnergy(slot);
    }

    @Override
    public FloatingLong extract(IStrictEnergyHandler storage, int slot, long amount, boolean simulate) {
        return storage.extractEnergy(FloatingLong.create((long)amount), simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public int getSlots(IStrictEnergyHandler handler) {
        return 1;
    }

    @Override
    public long getMaxStackSize(FloatingLong stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxStackSizeForSlot(IStrictEnergyHandler storage, int slot) {
        return storage.getMaxEnergy(slot).longValue();
    }

    @Override
    public FloatingLong insert(IStrictEnergyHandler storage, int slot, FloatingLong amount, boolean simulate) {
        FloatingLong remainder = storage.insertEnergy(amount, simulate ? Action.SIMULATE : Action.EXECUTE);
        return remainder;
    }

    @Override
    public boolean isEmpty(FloatingLong stack) {
        return stack.isZero();
    }

    @Override
    public boolean matchesCapabilityType(Object o) {
        return o instanceof IStrictEnergyHandler;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(FloatingLong floatingLong) {
        return Stream.empty();
    }

    @Override
    public FloatingLong getEmptyStack() {
        return FloatingLong.ZERO;
    }

    @Override
    public FloatingLong copy(FloatingLong stack) {
        return stack;
    }

    @Override
    protected FloatingLong setCount(FloatingLong stack, long amount) {
        return FloatingLong.create((long)amount);
    }

    @Override
    public FloatingLong withCount(FloatingLong floatingLong, long count) {
        return FloatingLong.create((long)count);
    }
}

