/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.capability.BlockEntityCapabilityProvider;
import ca.teamdman.sfm.common.capability.CauldronBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.ae2.EnergyAcceptorBlockCapabilityProvider;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class SFMBlockCapabilityProviders {
    public static final ResourceLocation REGISTRY_ID = SFMResourceLocation.fromSFMPath("capability_provider_mappers");
    @Nullable
    public static final RegistryObject<EnergyAcceptorBlockCapabilityProvider> AE2_ENERGY_ACCEPTOR_CAPABILITY_PROVIDER_MAPPER;
    private static final DeferredRegister<SFMBlockCapabilityProvider<?>> REGISTERER;
    private static final Supplier<IForgeRegistry<SFMBlockCapabilityProvider<?>>> REGISTRY;
    @MCVersionDependentBehaviour
    public static final Supplier<CauldronBlockCapabilityProvider> CAULDRON_MAPPER;
    public static final Supplier<BlockEntityCapabilityProvider> BLOCK_ENTITY;

    public static ArrayList<SFMBlockCapabilityProvider<?>> getAllProviders() {
        ArrayList providers = new ArrayList(REGISTRY.get().getValues());
        providers.sort(Comparator.comparingInt(provider -> provider.priority()).reversed());
        return providers;
    }

    @MCVersionDependentBehaviour
    public static SFMRegistryWrapper<SFMBlockCapabilityProvider<?>> registry() {
        return new SFMRegistryWrapper(REGISTRY.get());
    }

    public static void register(IEventBus bus) {
        REGISTERER.register(bus);
    }

    static {
        REGISTERER = DeferredRegister.create((ResourceLocation)REGISTRY_ID, (String)"sfm");
        REGISTRY = REGISTERER.makeRegistry(() -> new RegistryBuilder().setName(REGISTRY_ID));
        CAULDRON_MAPPER = REGISTERER.register("cauldron", CauldronBlockCapabilityProvider::new);
        BLOCK_ENTITY = REGISTERER.register("block_entity", BlockEntityCapabilityProvider::new);
        AE2_ENERGY_ACCEPTOR_CAPABILITY_PROVIDER_MAPPER = SFMModCompat.isAE2Loaded() ? REGISTERER.register("ae2/energy_acceptor", EnergyAcceptorBlockCapabilityProvider::new) : null;
    }
}

