/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client;

import ca.teamdman.sfm.client.screen.SFMConfirmationScreen;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.common.facade.FacadePlanner;
import ca.teamdman.sfm.common.facade.IFacadePlan;
import ca.teamdman.sfm.common.net.ServerboundFacadePacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.ConfirmationParams;
import ca.teamdman.sfm.common.util.SFMPlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ClientFacadeWarningHelper {
    public static void sendFacadePacketFromClientWithConfirmationIfNecessary(ServerboundFacadePacket msg) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        assert (player != null);
        Level level = SFMPlayerUtils.getLevel((Player)player);
        IFacadePlan facadePlan = FacadePlanner.getFacadePlan((Player)player, level, msg);
        if (facadePlan == null) {
            return;
        }
        ConfirmationParams warning = facadePlan.computeWarning(level);
        if (warning == null) {
            SFMPackets.sendToServer(msg);
            facadePlan.apply(level);
        } else {
            SFMScreenChangeHelpers.setOrPushScreen((Screen)new SFMConfirmationScreen(warning, 10, () -> {
                SFMPackets.sendToServer(msg);
                facadePlan.apply(level);
            }));
        }
    }
}

