/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.diagnostics;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.forge.ForgeVersion;

public class SFMClientDiagnostics {
    public static String getDiagnosticsSummary(ItemStack diskStack) {
        StringBuilder content = new StringBuilder();
        try {
            List<TranslatableContents> warnings;
            content.append("-- Diagnostic info --\n");
            content.append("-- Program:\n").append(DiskItem.getProgram(diskStack)).append("\n\n");
            content.append("-- DateTime: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm.ss").format(new Date())).append('\n');
            content.append("-- Game Version: ").append("Minecraft ").append(SharedConstants.m_183709_().m_132493_()).append(" (").append(Minecraft.m_91087_().m_91388_()).append("/").append(ClientBrandRetriever.m_129629_()).append(")").append('\n');
            content.append("-- Forge Version: ").append(ForgeVersion.getVersion()).append('\n');
            ModList.get().getModContainerById("sfm").ifPresent(mod -> content.append("-- SFM Version: ").append(mod.getModInfo().getVersion()).append('\n'));
            List<TranslatableContents> errors = DiskItem.getErrors(diskStack);
            if (!errors.isEmpty()) {
                content.append("\n-- Errors\n");
                for (TranslatableContents error : errors) {
                    content.append("-- * ").append(I18n.m_118938_((String)error.m_237508_(), (Object[])error.m_237523_())).append("\n");
                }
            }
            if (!(warnings = DiskItem.getWarnings(diskStack)).isEmpty()) {
                content.append("\n-- Warnings\n");
                for (TranslatableContents warning : warnings) {
                    content.append("-- * ").append(I18n.m_118938_((String)warning.m_237508_(), (Object[])warning.m_237523_())).append("\n");
                }
            }
            LabelPositionHolder labels = LabelPositionHolder.from(diskStack);
            content.append("\n-- Labels\n").append(labels.toDebugString());
        }
        catch (Throwable t) {
            SFM.LOGGER.error("Failed gathering diagnostic info, returning partial results. Error: ", t);
        }
        return content.toString();
    }
}

