/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ResourcesProgramLinter
implements IProgramLinter {
    @Override
    public ArrayList<TranslatableContents> gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity managerBlockEntity) {
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        for (ResourceIdentifier<?, ?, ?> resource : program.referencedResources()) {
            Optional<ResourceLocation> loc = resource.getLocation();
            if (loc.isEmpty() || resource.getResourceType() == null || resource.getResourceType().registryKeyExists(loc.get())) continue;
            warnings.add(LocalizationKeys.PROGRAM_WARNING_UNKNOWN_RESOURCE_ID.get(resource));
        }
        return warnings;
    }

    @Override
    public void fixWarnings(ManagerBlockEntity managerBlockEntity, ItemStack diskStack, Program program) {
    }
}

