/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;

public class SFMTranslationUtils {
    public static final int MAX_TRANSLATION_ELEMENT_LENGTH = 10240;

    public static TranslatableContents deserializeTranslation(CompoundTag tag) {
        String key = tag.m_128461_("key");
        Object[] args = tag.m_128437_("args", 8).stream().map(StringTag.class::cast).map(StringTag::m_7916_).toArray();
        return SFMTranslationUtils.getTranslatableContents(key, args);
    }

    public static CompoundTag serializeTranslation(TranslatableContents contents) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("key", contents.m_237508_());
        ListTag args = new ListTag();
        for (Object arg : contents.m_237523_()) {
            args.add((Object)StringTag.m_129297_((String)arg.toString()));
        }
        tag.m_128365_("args", (Tag)args);
        return tag;
    }

    public static void encodeTranslation(TranslatableContents contents, FriendlyByteBuf buf) {
        buf.m_130072_(contents.m_237508_(), 10240);
        buf.m_130130_(contents.m_237523_().length);
        for (Object arg : contents.m_237523_()) {
            buf.m_130072_(String.valueOf(arg), 10240);
        }
    }

    public static TranslatableContents decodeTranslation(FriendlyByteBuf buf) {
        String key = buf.m_130136_(10240);
        int argCount = buf.m_130242_();
        Object[] args = new Object[argCount];
        for (int i = 0; i < argCount; ++i) {
            args[i] = buf.m_130136_(10240);
        }
        return SFMTranslationUtils.getTranslatableContents(key, args);
    }

    @MCVersionDependentBehaviour
    public static TranslatableContents getTranslatableContents(String key, Object ... args) {
        return new TranslatableContents(key, null, args);
    }

    public static TranslatableContents getTranslatableContents(String key) {
        return SFMTranslationUtils.getTranslatableContents(key, new Object[0]);
    }
}

