/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.collect.Multiset;
import org.simmetrics.MultisetDistance;
import org.simmetrics.MultisetMetric;
import org.simmetrics.metrics.Math;

public final class CosineSimilarity<T>
implements MultisetMetric<T>,
MultisetDistance<T> {
    @Override
    public float compare(Multiset<T> a, Multiset<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        float dotProduct = 0.0f;
        float magnitudeA = 0.0f;
        float magnitudeB = 0.0f;
        for (Object entry : Math.union(a, b).elementSet()) {
            float aCount = a.count(entry);
            float bCount = b.count(entry);
            dotProduct += aCount * bCount;
            magnitudeA += aCount * aCount;
            magnitudeB += bCount * bCount;
        }
        return (float)((double)dotProduct / (java.lang.Math.sqrt(magnitudeA) * java.lang.Math.sqrt(magnitudeB)));
    }

    @Override
    public float distance(Multiset<T> a, Multiset<T> b) {
        return 1.0f - this.compare(a, b);
    }

    public String toString() {
        return "CosineSimilarity";
    }
}

