/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record ServerboundDiskItemSetProgramPacket(String programString, InteractionHand hand) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ServerboundDiskItemSetProgramPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundDiskItemSetProgramPacket msg, RegistryFriendlyByteBuf buf) {
            buf.writeUtf(msg.programString, 32367);
            buf.writeEnum((Enum)msg.hand);
        }

        @Override
        public ServerboundDiskItemSetProgramPacket decode(RegistryFriendlyByteBuf buf) {
            return new ServerboundDiskItemSetProgramPacket(buf.readUtf(32367), (InteractionHand)buf.readEnum(InteractionHand.class));
        }

        @Override
        public void handle(ServerboundDiskItemSetProgramPacket msg, SFMPacketHandlingContext context) {
            ServerPlayer sender = context.sender();
            if (sender == null) {
                return;
            }
            ItemStack stack = sender.getItemInHand(msg.hand);
            if (stack.getItem() instanceof DiskItem) {
                DiskItem.setProgram(stack, msg.programString);
                DiskItem.compileAndUpdateErrorsAndWarnings(stack, null);
                DiskItem.pruneIfDefault(stack);
            }
        }

        @Override
        public Class<ServerboundDiskItemSetProgramPacket> getPacketClass() {
            return ServerboundDiskItemSetProgramPacket.class;
        }
    }
}

