/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.RelativeSide;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MekanismSideConfigProgramLinter
implements IProgramLinter {
    @Override
    public ArrayList<TranslatableContents> gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity managerBlockEntity) {
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        if (!SFMModCompat.isMekanismLoaded()) {
            return warnings;
        }
        if (managerBlockEntity == null) {
            return warnings;
        }
        Level level = managerBlockEntity.getLevel();
        if (level == null) {
            return warnings;
        }
        program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> MekanismSideConfigProgramLinter.addWarningsForMekanismAccess(statement, labelPositionHolder, statement, level, warnings));
        return warnings;
    }

    @Override
    public void fixWarnings(ManagerBlockEntity managerBlockEntity, ItemStack diskStack, Program program) {
        if (!SFMModCompat.isMekanismLoaded()) {
            return;
        }
        if (managerBlockEntity == null || managerBlockEntity.getLevel() == null) {
            return;
        }
        Level level = managerBlockEntity.getLevel();
        program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> MekanismSideConfigProgramLinter.fixWarningsByModifyingMekanismAccess(statement, LabelPositionHolder.from(diskStack), level));
    }

    private static void addWarningsForMekanismAccess(IOStatement ioStatement, LabelPositionHolder labelPositionHolder, IOStatement statement, Level level, ArrayList<TranslatableContents> warnings) {
        if (!SFMModCompat.isMekanismLoaded()) {
            return;
        }
        DirectionQualifier directions = statement.labelAccess().directions();
        Stream<Pair> mekanismBlocks = statement.labelAccess().getLabelledPositions(labelPositionHolder).stream().filter(pair -> level.isLoaded((BlockPos)pair.getSecond())).filter(pair -> SFMModCompat.isMekanismBlock(level, (BlockPos)pair.getSecond()));
        if (directions.equals(DirectionQualifier.NULL_DIRECTION)) {
            mekanismBlocks.forEach(pair -> warnings.add(LocalizationKeys.PROGRAM_WARNING_MEKANISM_USED_WITHOUT_DIRECTION.get(pair.getFirst(), statement.toStringPretty())));
        } else {
            Predicate<DataType> dataTypePredicate;
            EnumSet<TransmissionType> referencedTransmissionTypes = SFMMekanismCompat.getReferencedTransmissionTypes(statement);
            if (ioStatement instanceof InputStatement) {
                dataTypePredicate = dataType -> dataType.canOutput() || dataType == DataType.EXTRA;
            } else if (ioStatement instanceof OutputStatement) {
                dataTypePredicate = dataType -> dataType == DataType.INPUT || dataType == DataType.INPUT_OUTPUT || dataType == DataType.INPUT_1 || dataType == DataType.INPUT_2 || dataType == DataType.EXTRA;
            } else {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(ioStatement));
            }
            mekanismBlocks.forEach(pair -> {
                BlockPos blockPos = (BlockPos)pair.getSecond();
                BlockEntity patt0$temp = level.getBlockEntity(blockPos);
                if (patt0$temp instanceof ISideConfiguration) {
                    ISideConfiguration mekBlockEntity = (ISideConfiguration)patt0$temp;
                    TileComponentConfig config = mekBlockEntity.getConfig();
                    for (TransmissionType transmissionType : referencedTransmissionTypes) {
                        boolean anySuccess = false;
                        ConfigInfo transmissionConfig = config.getConfig(transmissionType);
                        if (transmissionConfig != null) {
                            Set<Direction> activeSides = SFMMekanismCompat.getSides(transmissionConfig, mekBlockEntity, dataTypePredicate);
                            for (Direction direction : directions) {
                                if (!activeSides.contains(direction)) continue;
                                anySuccess = true;
                                break;
                            }
                        }
                        if (anySuccess) continue;
                        warnings.add(LocalizationKeys.PROGRAM_WARNING_MEKANISM_BAD_SIDE_CONFIG.get(blockPos, pair.getFirst(), statement.toStringPretty()));
                    }
                }
            });
        }
    }

    private static void fixWarningsByModifyingMekanismAccess(IOStatement statement, LabelPositionHolder labelPositionHolder, Level level) {
        DataType fixed;
        Predicate<DataType> dataTypePredicate;
        DirectionQualifier directions = statement.labelAccess().directions();
        Stream<Pair> mekanismBlocks = statement.labelAccess().getLabelledPositions(labelPositionHolder).stream().filter(pair -> SFMModCompat.isMekanismBlock(level, (BlockPos)pair.getSecond()));
        EnumSet<TransmissionType> referencedTransmissionTypes = SFMMekanismCompat.getReferencedTransmissionTypes(statement);
        if (statement instanceof InputStatement) {
            dataTypePredicate = DataType::canOutput;
            fixed = DataType.OUTPUT;
        } else if (statement instanceof OutputStatement) {
            dataTypePredicate = dataType -> dataType == DataType.INPUT || dataType == DataType.INPUT_OUTPUT || dataType == DataType.INPUT_1 || dataType == DataType.INPUT_2;
            fixed = DataType.INPUT;
        } else {
            throw new IllegalStateException("Unexpected value: " + String.valueOf(statement));
        }
        mekanismBlocks.forEach(pair -> {
            BlockPos blockPos = (BlockPos)pair.getSecond();
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (patt0$temp instanceof ISideConfiguration) {
                ISideConfiguration mekBlockEntity = (ISideConfiguration)patt0$temp;
                TileComponentConfig mekBlockEntityConfig = mekBlockEntity.getConfig();
                for (TransmissionType transmissionType : referencedTransmissionTypes) {
                    Direction statementSide;
                    ConfigInfo transmissionConfig = mekBlockEntityConfig.getConfig(transmissionType);
                    if (transmissionConfig == null) continue;
                    Set<Direction> activeSides = SFMMekanismCompat.getSides(transmissionConfig, mekBlockEntity, dataTypePredicate);
                    boolean anySuccess = directions.stream().anyMatch(activeSides::contains);
                    if (anySuccess || (statementSide = directions.iterator().next()) == null) continue;
                    RelativeSide relativeSide = RelativeSide.fromDirections((Direction)mekBlockEntity.getDirection(), (Direction)statementSide);
                    transmissionConfig.setDataType(fixed, relativeSide);
                    mekBlockEntityConfig.sideChanged(transmissionType, relativeSide);
                }
            }
        });
    }
}

