/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.collect.Multiset;
import org.simmetrics.MultisetDistance;
import org.simmetrics.MultisetMetric;
import org.simmetrics.metrics.Math;

public final class EuclideanDistance<T>
implements MultisetMetric<T>,
MultisetDistance<T> {
    @Override
    public float compare(Multiset<T> a, Multiset<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        float maxDistance = (float)java.lang.Math.sqrt(a.size() * a.size() + b.size() * b.size());
        return 1.0f - this.distance(a, b) / maxDistance;
    }

    @Override
    public float distance(Multiset<T> a, Multiset<T> b) {
        float distance = 0.0f;
        for (Object token : Math.union(a, b).elementSet()) {
            float frequencyInA = a.count(token);
            float frequencyInB = b.count(token);
            distance += (frequencyInA - frequencyInB) * (frequencyInA - frequencyInB);
        }
        return (float)java.lang.Math.sqrt(distance);
    }

    public String toString() {
        return "EuclideanDistance";
    }
}

