/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import org.simmetrics.StringDistance;
import org.simmetrics.StringMetric;

public final class LongestCommonSubsequence
implements StringMetric,
StringDistance {
    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        return (float)LongestCommonSubsequence.lcs(a, b) / (float)Math.max(a.length(), b.length());
    }

    @Override
    public float distance(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 0.0f;
        }
        if (a.isEmpty()) {
            return b.length();
        }
        if (b.isEmpty()) {
            return a.length();
        }
        return a.length() + b.length() - 2 * LongestCommonSubsequence.lcs(a, b);
    }

    private static int lcs(String a, String b) {
        int n = a.length();
        int m = b.length();
        int[] v0 = new int[m + 1];
        int[] v1 = new int[m + 1];
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                v1[j] = a.charAt(i - 1) == b.charAt(j - 1) ? v0[j - 1] + 1 : Math.max(v1[j - 1], v0[j]);
            }
            int[] swap = v0;
            v0 = v1;
            v1 = swap;
        }
        return v0[m];
    }

    public String toString() {
        return "LongestCommonSubsequence";
    }
}

