/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.common.containermenu.TestBarrelTankContainerMenu;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class TestBarrelTankScreen
extends AbstractContainerScreen<TestBarrelTankContainerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = SFMResourceLocation.fromSFMPath("textures/gui/container/manager.png");

    public TestBarrelTankScreen(TestBarrelTankContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
        this.renderTooltip(graphics, mx, my);
        FluidStack fluidStack = new FluidStack((Fluid)Fluids.WATER, 1000);
        IClientFluidTypeExtensions fluidType = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation fluidSpriteLocation = fluidType.getFlowingTexture(fluidStack);
        TextureAtlasSprite fluidSprite = (TextureAtlasSprite)this.getMinecraft().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(fluidSpriteLocation);
        int fluidColour = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)fluidColour) / 255.0f), (float)((float)FastColor.ARGB32.green((int)fluidColour) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)fluidColour) / 255.0f), (float)((float)FastColor.ARGB32.alpha((int)fluidColour) / 255.0f));
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        BufferBuilder vertexBuffer = Tesselator.getInstance().getBuilder();
        vertexBuffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = graphics.pose().last().pose();
        vertexBuffer.vertex(matrix, 0.0f, 128.0f, 1.0f).uv(fluidSprite.getU0(), fluidSprite.getV1()).endVertex();
        vertexBuffer.vertex(matrix, 128.0f, 128.0f, 1.0f).uv(fluidSprite.getU1(), fluidSprite.getV1()).endVertex();
        vertexBuffer.vertex(matrix, 128.0f, 0.0f, 1.0f).uv(fluidSprite.getU1(), fluidSprite.getV0()).endVertex();
        vertexBuffer.vertex(matrix, 0.0f, 0.0f, 1.0f).uv(fluidSprite.getU0(), fluidSprite.getV0()).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)vertexBuffer.end());
        RenderSystem.disableBlend();
    }

    protected void init() {
        super.init();
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    @MCVersionDependentBehaviour
    protected void renderTooltip(GuiGraphics pGuiGraphics, int mx, int my) {
        this.drawChildTooltips(pGuiGraphics, mx, my);
        super.renderTooltip(pGuiGraphics, mx, my);
    }

    @MCVersionDependentBehaviour
    private void drawChildTooltips(GuiGraphics guiGraphics, int mx, int my) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mx, int my) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BACKGROUND_TEXTURE_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }
}

