/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.text_styling;

import ca.teamdman.langs.SFMLLexer;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;

public class ProgramSyntaxHighlightingHelper {
    public static List<MutableComponent> withSyntaxHighlighting(String programString, boolean showContextActionHints) {
        Token token;
        SFMLLexer lexer = new SFMLLexer((CharStream)CharStreams.fromString((String)programString));
        lexer.INCLUDE_UNUSED = true;
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer){

            public List<Token> getHiddenTokensToRight(int tokenIndex, int channel) {
                if (channel == 0) {
                    return this.getHiddenTokensToRight(tokenIndex, 1);
                }
                return super.getHiddenTokensToRight(tokenIndex, channel);
            }

            public List<Token> getHiddenTokensToLeft(int tokenIndex, int channel) {
                if (channel == 0) {
                    return this.getHiddenTokensToLeft(tokenIndex, 1);
                }
                return super.getHiddenTokensToLeft(tokenIndex, channel);
            }
        };
        ArrayList<MutableComponent> textComponents = new ArrayList<MutableComponent>();
        MutableComponent lineComponent = Component.empty();
        tokens.fill();
        Iterator iterator = tokens.getTokens().iterator();
        while (iterator.hasNext() && (token = (Token)iterator.next()).getType() != -1) {
            String[] lines = token.getText().split("\n", -1);
            for (int i = 0; i < lines.length; ++i) {
                String line;
                if (i != 0) {
                    textComponents.add(lineComponent);
                    lineComponent = Component.empty();
                }
                if ((line = lines[i]).isEmpty()) continue;
                MutableComponent text = Component.literal((String)line).withStyle(ProgramSyntaxHighlightingHelper.getStyle(token, showContextActionHints));
                lineComponent = lineComponent.append((Component)text);
            }
        }
        textComponents.add(lineComponent);
        return textComponents;
    }

    private static Style getStyle(Token token, boolean showContextActionHints) {
        Style style = Style.EMPTY;
        style = style.withColor(ProgramSyntaxHighlightingHelper.getColour(token));
        if (showContextActionHints && ProgramTokenContextActions.hasContextAction(token)) {
            style = style.withUnderlined(Boolean.valueOf(true));
        }
        return style;
    }

    private static ChatFormatting getColour(Token token) {
        switch (token.getType()) {
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                return ChatFormatting.DARK_PURPLE;
            }
            case 80: {
                return ChatFormatting.GRAY;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return ChatFormatting.LIGHT_PURPLE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 34: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                return ChatFormatting.BLUE;
            }
            case 78: 
            case 79: {
                return ChatFormatting.GREEN;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                return ChatFormatting.GOLD;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 63: 
            case 77: {
                return ChatFormatting.AQUA;
            }
            case 64: 
            case 65: 
            case 82: {
                return ChatFormatting.RED;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return ChatFormatting.YELLOW;
            }
        }
        return ChatFormatting.WHITE;
    }
}

