/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.recipe.NotContainer;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class PrintingPressBlockEntity
extends BlockEntity
implements NotContainer {
    private final ItemStackHandler FORM = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PrintingPressBlockEntity.this.setChanged();
            if (PrintingPressBlockEntity.this.level != null) {
                PrintingPressBlockEntity.this.level.sendBlockUpdated(PrintingPressBlockEntity.this.worldPosition, PrintingPressBlockEntity.this.getBlockState(), PrintingPressBlockEntity.this.getBlockState(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getItem() == SFMItems.FORM_ITEM.get();
        }
    };
    private final ItemStackHandler INK = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PrintingPressBlockEntity.this.setChanged();
            if (PrintingPressBlockEntity.this.level != null) {
                PrintingPressBlockEntity.this.level.sendBlockUpdated(PrintingPressBlockEntity.this.worldPosition, PrintingPressBlockEntity.this.getBlockState(), PrintingPressBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (PrintingPressBlockEntity.this.getLevel() == null) {
                return false;
            }
            return PrintingPressBlockEntity.this.getLevel().getRecipeManager().getAllRecipesFor(SFMRecipeTypes.PRINTING_PRESS.get()).stream().anyMatch(r -> ((PrintingPressRecipe)r.value()).ink().test(stack));
        }
    };
    private final ItemStackHandler PAPER = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PrintingPressBlockEntity.this.setChanged();
            if (PrintingPressBlockEntity.this.level != null) {
                PrintingPressBlockEntity.this.level.sendBlockUpdated(PrintingPressBlockEntity.this.worldPosition, PrintingPressBlockEntity.this.getBlockState(), PrintingPressBlockEntity.this.getBlockState(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (PrintingPressBlockEntity.this.getLevel() == null) {
                return false;
            }
            return PrintingPressBlockEntity.this.getLevel().getRecipeManager().getAllRecipesFor(SFMRecipeTypes.PRINTING_PRESS.get()).stream().anyMatch(r -> ((PrintingPressRecipe)r.value()).paper().test(stack));
        }
    };
    public final CombinedInvWrapper INVENTORY = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.FORM, this.INK, this.PAPER});

    public PrintingPressBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(SFMBlockEntities.PRINTING_PRESS_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.readItems(tag);
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        this.writeItems(tag);
    }

    private void writeItems(CompoundTag tag) {
        tag.put("form", (Tag)this.FORM.serializeNBT());
        tag.put("paper", (Tag)this.PAPER.serializeNBT());
        tag.put("ink", (Tag)this.INK.serializeNBT());
    }

    private void readItems(CompoundTag tag) {
        this.INK.deserializeNBT(tag.getCompound("ink"));
        this.PAPER.deserializeNBT(tag.getCompound("paper"));
        this.FORM.deserializeNBT(tag.getCompound("form"));
    }

    public ItemStack acceptStack(ItemStack stack) {
        if (!stack.isEmpty()) {
            ItemStack remainder = this.FORM.insertItem(0, stack.copy(), false);
            if (remainder.getCount() < stack.getCount()) {
                stack.shrink(stack.getCount() - remainder.getCount());
                return stack;
            }
            remainder = this.INK.insertItem(0, stack.copy(), false);
            if (remainder.getCount() < stack.getCount()) {
                stack.shrink(stack.getCount() - remainder.getCount());
                return stack;
            }
            remainder = this.PAPER.insertItem(0, stack.copy(), false);
            if (remainder.getCount() < stack.getCount()) {
                stack.shrink(stack.getCount() - remainder.getCount());
                return stack;
            }
        } else {
            ItemStack found = this.PAPER.extractItem(0, 64, false);
            if (!found.isEmpty()) {
                return found;
            }
            found = this.FORM.extractItem(0, 64, false);
            if (!found.isEmpty()) {
                return found;
            }
            found = this.INK.extractItem(0, 64, false);
            if (!found.isEmpty()) {
                return found;
            }
        }
        return stack;
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.writeItems(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.readItems(tag);
        }
    }

    public ItemStack getPaper() {
        return this.PAPER.getStackInSlot(0);
    }

    public ItemStack getInk() {
        return this.INK.getStackInSlot(0);
    }

    public ItemStack getForm() {
        return this.FORM.getStackInSlot(0);
    }

    public void performPrint() {
        if (this.getLevel() == null) {
            return;
        }
        RecipeManager recipeManager = this.getLevel().getRecipeManager();
        recipeManager.getRecipeFor(SFMRecipeTypes.PRINTING_PRESS.get(), (Container)this, this.getLevel()).ifPresent(recipe -> {
            ItemStack paper = this.getPaper();
            ItemStack ink = this.getInk();
            ItemStack form = this.getForm();
            if (paper.isEmpty() || ink.isEmpty() || form.isEmpty()) {
                return;
            }
            paper = ((PrintingPressRecipe)recipe.value()).assemble(this, this.getLevel().registryAccess());
            this.PAPER.setStackInSlot(0, paper);
            ink.shrink(1);
            this.INK.setStackInSlot(0, ink);
        });
    }

    @MCVersionDependentBehaviour
    private ItemStack assembleRecipe(PrintingPressRecipe recipe) {
        assert (this.level != null);
        return recipe.assemble(this, this.level.registryAccess());
    }

    public ItemStack[] getStacksToDrop() {
        return new ItemStack[]{this.getPaper(), this.getInk(), this.getForm()};
    }
}

