/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.command;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.export.ClientExportHelper;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.command.ConfigCommand;
import ca.teamdman.sfm.common.command.ConfigCommandBehaviourInput;
import ca.teamdman.sfm.common.command.ConfigCommandVariantInput;
import ca.teamdman.sfm.common.net.ClientboundShowChangelogPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.watertanknetwork.WaterNetworkManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.server.command.EnumArgument;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="sfm")
public class SFMCommand {
    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = Commands.literal((String)"sfm");
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"bust_cable_network_cache").requires(source -> source.hasPermission(0))).executes(ctx -> {
            SFM.LOGGER.info("Busting cable networks - slash command used by {}", (Object)((CommandSourceStack)ctx.getSource()).getTextName());
            CableNetworkManager.clear();
            return 1;
        }));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"bust_water_network_cache").requires(source -> source.hasPermission(0))).executes(ctx -> {
            SFM.LOGGER.info("Busting water networks - slash command used by {}", (Object)((CommandSourceStack)ctx.getSource()).getTextName());
            WaterNetworkManager.clear();
            return 1;
        }));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"show_bad_cable_cache_entries").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)event.getBuildContext())).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
            CableNetworkManager.getBadCableCachePositions((Level)level).forEach(pos -> {
                BlockInput block = BlockStateArgument.getBlock((CommandContext)ctx, (String)"block");
                block.place(level, pos, 3);
            });
            return 1;
        })));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"config").then(((LiteralArgumentBuilder)Commands.literal((String)"show").requires(source -> source.hasPermission(0))).then(Commands.argument((String)"variant", (ArgumentType)EnumArgument.enumArgument(ConfigCommandVariantInput.class)).executes(ctx -> new ConfigCommand(ConfigCommandBehaviourInput.SHOW, (ConfigCommandVariantInput)((Object)((Object)ctx.getArgument("variant", ConfigCommandVariantInput.class)))).run((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)Commands.literal((String)"edit").then(((LiteralArgumentBuilder)Commands.literal((String)ConfigCommandVariantInput.SERVER.name()).requires(source -> source.hasPermission(4))).executes((Command)new ConfigCommand(ConfigCommandBehaviourInput.EDIT, ConfigCommandVariantInput.SERVER)))).then(((LiteralArgumentBuilder)Commands.literal((String)ConfigCommandVariantInput.CLIENT.name()).requires(source -> source.hasPermission(0))).executes((Command)new ConfigCommand(ConfigCommandBehaviourInput.EDIT, ConfigCommandVariantInput.CLIENT)))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"changelog").requires(source -> source.hasPermission(0))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
            if (player != null) {
                SFMPackets.sendToPlayer(player, (Object)new ClientboundShowChangelogPacket());
            }
            return 1;
        }));
        if (FMLEnvironment.dist.isClient()) {
            command.then(((LiteralArgumentBuilder)Commands.literal((String)"export_info").requires(source -> source.hasPermission(0))).then(Commands.argument((String)"includeHidden", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
                boolean includeHidden = BoolArgumentType.getBool((CommandContext)ctx, (String)"includeHidden");
                SFM.LOGGER.info("Exporting info, includeHidden={} - slash command used by {}", (Object)includeHidden, (Object)((CommandSourceStack)ctx.getSource()).getTextName());
                assert (Minecraft.getInstance().player != null);
                new Thread(() -> {
                    try {
                        long start = System.currentTimeMillis();
                        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"Beginning item export"));
                        ClientExportHelper.dumpItems((Player)((CommandSourceStack)ctx.getSource()).getPlayer());
                        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"Beginning JEI export"));
                        long end = System.currentTimeMillis();
                        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)("Exported data in " + (end - start) + "ms")).withStyle(ChatFormatting.GREEN));
                    }
                    catch (Exception e) {
                        SFM.LOGGER.error("Failed to export item data", (Throwable)e);
                    }
                }).start();
                return 1;
            })));
        }
        event.getDispatcher().register(command);
    }
}

