/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.event_bus;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.event_bus.SFMEventBus;
import ca.teamdman.sfm.common.event_bus.SFMSubscribeEvent;
import ca.teamdman.sfm.common.util.SFMAnnotationUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.IModBusEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFMEventListenerMethod<T extends Event> {
    private final Method method;
    @Nullable
    private final Object target;
    private final SFMAnnotationUtils.SFMAnnotationData annotationData;
    private final SFMSubscribeEvent annotation;
    private final Class<T> eventClass;
    private final Class<?> methodParent;

    public SFMEventListenerMethod(Class<?> methodParent, Method method, @Nullable Object target, SFMAnnotationUtils.SFMAnnotationData annotationData, SFMSubscribeEvent annotation) {
        this.methodParent = methodParent;
        this.method = method;
        this.target = target;
        this.annotationData = annotationData;
        this.annotation = annotation;
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Event subscriber method must have exactly one parameter: " + String.valueOf(this));
        }
        Class<?> paramClass = method.getParameterTypes()[0];
        if (!Event.class.isAssignableFrom(paramClass)) {
            throw new IllegalArgumentException("Event subscriber method must have a single parameter of type Event: " + String.valueOf(this));
        }
        this.eventClass = paramClass;
    }

    public String toString() {
        return "SFMEventListenerMethod{" + this.methodParent.getName() + "#" + this.annotationData.memberName() + "}";
    }

    public static SFMEventListenerMethod<?> forStaticMethod(Class<?> methodParent, Method method, SFMAnnotationUtils.SFMAnnotationData annotationData, SFMSubscribeEvent annotation) {
        return new SFMEventListenerMethod(methodParent, method, null, annotationData, annotation);
    }

    public static SFMEventListenerMethod<?> forInstanceMethod(Class<?> methodParent, Method method, Object target, SFMAnnotationUtils.SFMAnnotationData annotationData, SFMSubscribeEvent annotation) {
        return new SFMEventListenerMethod(methodParent, method, target, annotationData, annotation);
    }

    public Consumer<T> createConsumer() {
        try {
            this.method.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = lookup.unreflect(this.method);
            if (this.target != null) {
                methodHandle = methodHandle.bindTo(this.target);
            }
            final MethodHandle adapted = methodHandle.asType(MethodType.methodType(Void.TYPE, Object.class));
            return new Consumer<T>(){

                @Override
                public void accept(T e) {
                    try {
                        adapted.invokeExact(e);
                    }
                    catch (Throwable t) {
                        if (t instanceof RuntimeException) {
                            RuntimeException re = (RuntimeException)t;
                            throw re;
                        }
                        if (t instanceof Error) {
                            Error err = (Error)t;
                            throw err;
                        }
                        throw new RuntimeException(t);
                    }
                }

                public String toString() {
                    return "SFMEventListenerMethod.createConsumer(){" + SFMEventListenerMethod.this.methodParent.getName() + "#" + SFMEventListenerMethod.this.annotationData.memberName() + "}";
                }
            };
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void register() {
        Consumer<T> consumer = this.createConsumer();
        Mod.EventBusSubscriber.Bus busType = this.getEventBusType();
        IEventBus eventBus = SFMEventBus.getEventBus(busType);
        eventBus.addListener(this.annotation.priority(), this.annotation.receiveCanceled(), this.eventClass, consumer);
        SFM.LOGGER.info("Registered bus={} listener={}", (Object)busType, consumer);
    }

    @NotNull
    private Mod.EventBusSubscriber.Bus getEventBusType() {
        Mod.EventBusSubscriber.Bus busType = IModBusEvent.class.isAssignableFrom(this.eventClass) ? SFMEventBus.EventBusType.MOD : SFMEventBus.EventBusType.GAME;
        return busType;
    }
}

