/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.registry.SFMDeferredRegister;
import ca.teamdman.sfm.common.registry.SFMDeferredRegisterBuilder;
import ca.teamdman.sfm.common.registry.SFMRegistryObject;
import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.resourcetype.FluidResourceType;
import ca.teamdman.sfm.common.resourcetype.ForgeEnergyResourceType;
import ca.teamdman.sfm.common.resourcetype.ItemResourceType;
import ca.teamdman.sfm.common.resourcetype.RedstoneResourceType;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import org.jetbrains.annotations.Nullable;

public class SFMResourceTypes {
    public static final ResourceKey<Registry<ResourceType<?, ?, ?>>> REGISTRY_ID = SFMResourceLocation.createSFMRegistryKey("resource_type");
    private static final SFMDeferredRegister<ResourceType<?, ?, ?>> REGISTERER = new SFMDeferredRegisterBuilder().namespace("sfm").registry(REGISTRY_ID).createNewRegistry().build();
    public static final SFMRegistryObject<ResourceType<?, ?, ?>, ItemResourceType> ITEM = REGISTERER.register("item", ItemResourceType::new);
    public static final SFMRegistryObject<ResourceType<?, ?, ?>, FluidResourceType> FLUID = REGISTERER.register("fluid", FluidResourceType::new);
    public static final SFMRegistryObject<ResourceType<?, ?, ?>, ForgeEnergyResourceType> FORGE_ENERGY = REGISTERER.register("forge_energy", ForgeEnergyResourceType::new);
    public static final SFMRegistryObject<ResourceType<?, ?, ?>, RedstoneResourceType> REDSTONE = REGISTERER.register("redstone", RedstoneResourceType::new);
    private static final Object2ObjectOpenHashMap<ResourceLocation, ResourceType<?, ?, ?>> DEFERRED_TYPES_BY_ID = new Object2ObjectOpenHashMap();

    public static int getResourceTypeCount() {
        return REGISTERER.size();
    }

    @Nullable
    public static ResourceType<?, ?, ?> fastLookup(ResourceLocation resourceTypeId) {
        return (ResourceType)DEFERRED_TYPES_BY_ID.computeIfAbsent((Object)resourceTypeId, i -> SFMResourceTypes.registry().get(resourceTypeId));
    }

    public static Stream<SFMBlockCapabilityKind<?>> getCapabilities() {
        return REGISTERER.registry().stream().map(resourceType -> resourceType.CAPABILITY_KIND);
    }

    public static void register(IEventBus bus) {
        REGISTERER.register(bus);
    }

    public static SFMRegistryWrapper<ResourceType<?, ?, ?>> registry() {
        return REGISTERER.registry();
    }
}

