/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public enum Side implements ASTNode
{
    TOP,
    BOTTOM,
    NORTH,
    SOUTH,
    EAST,
    WEST,
    LEFT,
    RIGHT,
    FRONT,
    BACK,
    NULL;


    public static Side fromDirection(@Nullable Direction direction) {
        if (direction == null) {
            return NULL;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> TOP;
            case Direction.DOWN -> BOTTOM;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    @Nullable
    public Direction resolve(BlockState blockState) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TOP -> Direction.UP;
            case BOTTOM -> Direction.DOWN;
            case NORTH -> Direction.NORTH;
            case SOUTH -> Direction.SOUTH;
            case EAST -> Direction.EAST;
            case WEST -> Direction.WEST;
            case LEFT -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).map(Direction::getClockWise).orElse(null);
            case RIGHT -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).map(Direction::getCounterClockWise).orElse(null);
            case FRONT -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).orElse(null);
            case BACK -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).map(Direction::getOpposite).orElse(null);
            case NULL -> null;
        };
    }
}

