/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.ClientRayCastHelpers;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ContainerScreenInspectorHandler {
    private static boolean visible = false;
    @Nullable
    private static AbstractContainerScreen<?> lastScreen = null;
    private static final Button exportInspectorButton = new SFMButtonBuilder().setSize(100, 20).setPosition(5, 50).setText(LocalizationKeys.CONTAINER_INSPECTOR_SHOW_EXPORTS_BUTTON).setOnPress(button -> {
        BlockEntity lookBlockEntity = ClientRayCastHelpers.getLookBlockEntity();
        if (lastScreen != null && lookBlockEntity != null) {
            SFMPackets.sendToServer(new ServerboundContainerExportsInspectionRequestPacket(ContainerScreenInspectorHandler.lastScreen.getMenu().containerId, lookBlockEntity.getBlockPos()));
        }
    }).build();

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        boolean shouldCapture = Minecraft.getInstance().screen instanceof AbstractContainerScreen;
        if (shouldCapture && visible && exportInspectorButton.clicked(event.getMouseX(), event.getMouseY())) {
            exportInspectorButton.playDownSound(Minecraft.getInstance().getSoundManager());
            exportInspectorButton.onClick(event.getMouseX(), event.getMouseY());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGuiRender(ScreenEvent.Render.Post event) {
        if (!visible) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2;
            lastScreen = screen2 = (AbstractContainerScreen)screen;
            AbstractContainerMenu menu = screen2.getMenu();
            int containerSlotCount = 0;
            int inventorySlotCount = 0;
            GuiGraphics graphics = event.getGuiGraphics();
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 350.0f);
            exportInspectorButton.render(graphics, event.getMouseX(), event.getMouseY(), event.getPartialTick());
            Font font = Minecraft.getInstance().font;
            for (Slot slot : menu.slots) {
                int colour;
                if (slot.container instanceof Inventory) {
                    colour = ChatFormatting.YELLOW.getColor();
                    ++inventorySlotCount;
                } else {
                    colour = 4095;
                    ++containerSlotCount;
                }
                SFMFontUtils.draw(graphics, font, (Component)Component.literal((String)Integer.toString(slot.getSlotIndex())), screen2.getGuiLeft() + slot.x, screen2.getGuiTop() + slot.y, colour, false);
            }
            MutableComponent notice = LocalizationKeys.CONTAINER_INSPECTOR_NOTICE_1.getComponent().withStyle(ChatFormatting.GOLD);
            int offset = font.width((FormattedText)notice) / 2;
            SFMFontUtils.draw(graphics, font, (Component)notice, screen2.width / 2 - offset, 5, 0xFFFFFF, true);
            notice = LocalizationKeys.CONTAINER_INSPECTOR_NOTICE_2.getComponent(((KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get()).getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GOLD);
            offset = font.width((FormattedText)notice) / 2;
            SFMFontUtils.draw(graphics, font, (Component)notice, screen2.width / 2 - offset, 16, 0xFFFFFF, true);
            SFMFontUtils.draw(graphics, font, (Component)LocalizationKeys.CONTAINER_INSPECTOR_CONTAINER_SLOT_COUNT.getComponent(Component.literal((String)String.valueOf(containerSlotCount)).withStyle(ChatFormatting.BLUE)), 5, 25, 0xFFFFFF, true);
            SFMFontUtils.draw(graphics, font, (Component)LocalizationKeys.CONTAINER_INSPECTOR_INVENTORY_SLOT_COUNT.getComponent(Component.literal((String)String.valueOf(inventorySlotCount)).withStyle(ChatFormatting.YELLOW)), 5, 40, 0xFFFFFF, true);
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public static void onKeyDown(ScreenEvent.KeyPressed.Pre event) {
        Screen screen;
        KeyMapping toggleKey = (KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get();
        boolean toggleKeyPressed = toggleKey.isActiveAndMatches(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()));
        if (toggleKeyPressed) {
            visible = !visible;
            event.setCanceled(true);
            return;
        }
        KeyMapping activateKey = (KeyMapping)SFMKeyMappings.ITEM_INSPECTOR_KEY.get();
        boolean activateKeyPressed = activateKey.isActiveAndMatches(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()));
        if (activateKeyPressed && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            ItemStack hoveredStack;
            AbstractContainerScreen acs = (AbstractContainerScreen)screen;
            Slot hoveredSlot = acs.hoveredSlot;
            if (hoveredSlot != null && !(hoveredStack = hoveredSlot.getItem()).isEmpty()) {
                SFMScreenChangeHelpers.showItemInspectorScreen(hoveredStack);
            }
        }
    }
}

