/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.overlay;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.SFMHandUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.overlay.ExtendedGui;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

public class NetworkToolReminderOverlay
implements IGuiOverlay {
    public void render(ExtendedGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        if (minecraft.options.hideGui) {
            return;
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (!NetworkToolReminderOverlay.shouldRender(minecraft)) {
            return;
        }
        Font font = minecraft.font;
        MutableComponent reminder = LocalizationKeys.NETWORK_TOOL_REMINDER_OVERLAY.getComponent(((KeyMapping)SFMKeyMappings.TOGGLE_NETWORK_TOOL_OVERLAY_KEY.get()).getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.YELLOW));
        int reminderWidth = font.width((FormattedText)reminder);
        int x = screenWidth / 2 - reminderWidth / 2;
        int y = 30;
        SFMFontUtils.draw(guiGraphics, font, (Component)reminder, x, y, FastColor.ARGB32.color((int)255, (int)172, (int)208, (int)255), true);
    }

    private static boolean shouldRender(Minecraft minecraft) {
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return false;
        }
        if (!((Boolean)SFMConfig.CLIENT_CONFIG.showNetworkToolReminderOverlay.get()).booleanValue()) {
            return false;
        }
        ItemStack networkTool = SFMHandUtils.getItemInEitherHand((Player)player, SFMItems.NETWORK_TOOL_ITEM.get());
        return !networkTool.isEmpty();
    }
}

