/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.registry;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="sfm", value={Dist.CLIENT})
public class SFMPackFinders {
    private static final String CLASSIC_PACK_PATH = "pack/classic";
    private static final String CLASSIC_PACK_ID = "sfm:classic";
    private static final String CLASSIC_PACK_DISPLAY_NAME = "SFM Classic";

    @SubscribeEvent
    public static void onRegisterPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        IModFileInfo modFileInfo = ModList.get().getModFileById("sfm");
        if (modFileInfo == null) {
            return;
        }
        Path classicRoot = modFileInfo.getFile().findResource(new String[]{CLASSIC_PACK_PATH});
        if (!Files.exists(classicRoot.resolve("pack.mcmeta"), new LinkOption[0])) {
            return;
        }
        event.addRepositorySource(consumer -> {
            final PathPackResources packResources = new PathPackResources(CLASSIC_PACK_DISPLAY_NAME, classicRoot, true);
            @MCVersionDependentBehaviour Pack pack = Pack.readMetaAndCreate((String)CLASSIC_PACK_ID, (Component)Component.literal((String)CLASSIC_PACK_DISPLAY_NAME), (boolean)false, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                public PackResources openPrimary(String p_294636_) {
                    return packResources;
                }

                public PackResources openFull(String p_251717_, Pack.Info p_294956_) {
                    return packResources;
                }
            }, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.BUILT_IN);
            consumer.accept(pack);
        });
    }
}

