/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.containermenu;

import ca.teamdman.sfm.common.blockentity.TestBarrelTankBlockEntity;
import ca.teamdman.sfm.common.registry.SFMMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TestBarrelTankContainerMenu
extends AbstractContainerMenu {
    public final Container container;
    public final FluidTank tank;

    public TestBarrelTankContainerMenu(int windowId, Inventory inv, Container container, FluidStack tankContents) {
        super(SFMMenus.TEST_BARREL_TANK_MENU.get(), windowId);
        TestBarrelTankContainerMenu.checkContainerSize((Container)container, (int)1);
        this.container = container;
        this.tank = new FluidTank(1000);
        this.tank.setFluid(tankContents);
        container.startOpen(inv.player);
        int i = -18;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(container, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)inv, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)inv, i1, 8 + i1 * 18, 161 + i));
        }
    }

    public TestBarrelTankContainerMenu(int windowId, Inventory inventory, FriendlyByteBuf buf) {
        this(windowId, inventory, (Container)new SimpleContainer(27), buf.readFluidStack());
    }

    public TestBarrelTankContainerMenu(int containerId, Inventory inventory, TestBarrelTankBlockEntity blockEntity) {
        this(containerId, inventory, (Container)blockEntity, blockEntity.getTank().getFluid());
    }

    public static void encode(TestBarrelTankBlockEntity blockEntity, FriendlyByteBuf buf) {
        buf.writeLong((long)blockEntity.getTank().getFluidAmount());
        buf.writeFluidStack(blockEntity.getTank().getFluid());
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        int containerEnd = this.container.getContainerSize();
        int inventoryEnd = this.slots.size();
        ItemStack contents = slot.getItem();
        ItemStack result = contents.copy();
        if (slotIndex < containerEnd ? !this.moveItemStackTo(contents, containerEnd, inventoryEnd, true) : !this.moveItemStackTo(contents, 0, containerEnd, false)) {
            return ItemStack.EMPTY;
        }
        if (contents.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return result;
    }
}

