/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.handler;

import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.util.NotStored;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="sfm")
public class OpenContainerTracker {
    private static final Map<BlockPos, Map<ServerPlayer, ManagerContainerMenu>> OPEN_CONTAINERS = new WeakHashMap<BlockPos, Map<ServerPlayer, ManagerContainerMenu>>();

    public static Stream<Map.Entry<ServerPlayer, ManagerContainerMenu>> getOpenManagerMenus(@NotStored BlockPos pos) {
        if (OPEN_CONTAINERS.containsKey(pos)) {
            return OPEN_CONTAINERS.get(pos).entrySet().stream();
        }
        return Stream.empty();
    }

    @SubscribeEvent
    public static void onOpenContainer(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getContainer();
            if (player instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)player;
                OPEN_CONTAINERS.computeIfAbsent(mcm.MANAGER_POSITION, k -> new HashMap()).put(serverPlayer, mcm);
            }
        }
    }

    @SubscribeEvent
    public static void onCloseContainer(PlayerContainerEvent.Close event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getContainer();
            if (player instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)player;
                if (OPEN_CONTAINERS.containsKey(mcm.MANAGER_POSITION)) {
                    OPEN_CONTAINERS.get(mcm.MANAGER_POSITION).remove(serverPlayer);
                    if (OPEN_CONTAINERS.get(mcm.MANAGER_POSITION).isEmpty()) {
                        OPEN_CONTAINERS.remove(mcm.MANAGER_POSITION);
                    }
                }
            }
        }
    }
}

