/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.net.ClientboundLabelInspectionResultsPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public record ServerboundLabelInspectionRequestPacket(String label) implements SFMPacket
{
    private static final int MAX_RESULTS_LENGTH = 20480;

    public static class Daddy
    implements SFMPacketDaddy<ServerboundLabelInspectionRequestPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundLabelInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeUtf(msg.label(), 256);
        }

        @Override
        public ServerboundLabelInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
            return new ServerboundLabelInspectionRequestPacket(friendlyByteBuf.readUtf(256));
        }

        @Override
        public void handle(ServerboundLabelInspectionRequestPacket msg, SFMPacketHandlingContext context) {
            LabelPositionHolder labelPositionHolder;
            ServerPlayer player = context.sender();
            if (player == null) {
                return;
            }
            SFM.LOGGER.info("Received label inspection request packet from player {}", (Object)player.getStringUUID());
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)abstractContainerMenu;
                SFM.LOGGER.info("Player is using a manager container menu - will append additional info to payload");
                labelPositionHolder = LabelPositionHolder.from(mcm.CONTAINER.getItem(0));
            } else {
                labelPositionHolder = player.getMainHandItem().is((Item)SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player.getMainHandItem()) : (player.getOffhandItem().is((Item)SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player.getOffhandItem()) : null);
            }
            if (labelPositionHolder == null) {
                SFM.LOGGER.info("Label holder wasn't found - aborting");
                return;
            }
            SFM.LOGGER.info("building payload");
            StringBuilder payload = new StringBuilder();
            payload.append("-- Positions for label \"").append(msg.label()).append("\" --\n");
            payload.append(labelPositionHolder.getPositions(msg.label()).size()).append(" assignments\n");
            payload.append("-- Summary --\n");
            labelPositionHolder.getPositions(msg.label()).forEach(pos -> {
                payload.append(pos.getX()).append(",").append(pos.getY()).append(",").append(pos.getZ());
                if (player.level().isLoaded(pos)) {
                    payload.append(" -- ").append(player.level().getBlockState(pos).getBlock().getName().getString());
                } else {
                    payload.append(" -- chunk not loaded");
                }
                payload.append("\n");
            });
            payload.append("\n\n\n-- Detailed --\n");
            for (BlockPos pos2 : labelPositionHolder.getPositions(msg.label())) {
                if (payload.length() > 20000) {
                    payload.append("... (truncated)");
                    break;
                }
                payload.append(pos2.getX()).append(",").append(pos2.getY()).append(",").append(pos2.getZ());
                if (player.level().isLoaded(pos2)) {
                    payload.append(" -- ").append(player.level().getBlockState(pos2).getBlock().getName().getString());
                    payload.append("\n").append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults(player.level(), pos2).indent(1));
                } else {
                    payload.append(" -- chunk not loaded");
                }
                payload.append("\n");
            }
            SFM.LOGGER.info("Sending payload response length={} to player {}", (Object)payload.length(), (Object)player.getStringUUID());
            SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundLabelInspectionResultsPacket(SFMPacketDaddy.truncate(payload.toString(), 20480)));
        }

        @Override
        public Class<ServerboundLabelInspectionRequestPacket> getPacketClass() {
            return ServerboundLabelInspectionRequestPacket.class;
        }
    }
}

