/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.command.ConfigCommandBehaviourInput;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMConfigReadWriter;
import ca.teamdman.sfm.common.net.ClientboundServerConfigCommandPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.registry.SFMPackets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public record ServerboundServerConfigRequestPacket(ConfigCommandBehaviourInput requestingEditMode) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ServerboundServerConfigRequestPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundServerConfigRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeEnum((Enum)msg.requestingEditMode());
        }

        @Override
        public ServerboundServerConfigRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
            return new ServerboundServerConfigRequestPacket((ConfigCommandBehaviourInput)friendlyByteBuf.readEnum(ConfigCommandBehaviourInput.class));
        }

        @Override
        public void handle(ServerboundServerConfigRequestPacket msg, SFMPacketHandlingContext context) {
            ServerPlayer player = context.sender();
            if (player == null) {
                SFM.LOGGER.error("Received {} from null player", (Object)this.getPacketClass().getName());
                return;
            }
            if (!player.hasPermissions(4) && msg.requestingEditMode() == ConfigCommandBehaviourInput.EDIT) {
                SFM.LOGGER.warn("Player {} tried to request server config for editing but does not have the necessary permissions, this should never happen o-o", (Object)player.getName().getString());
                return;
            }
            String configToml = SFMConfigReadWriter.getConfigToml(SFMConfig.SERVER_CONFIG_SPEC);
            if (configToml == null) {
                SFM.LOGGER.warn("Unable to get server config for player {}", (Object)player.getName().getString());
                player.sendSystemMessage((Component)SFMConfigReadWriter.ConfigSyncResult.INTERNAL_FAILURE.component());
                return;
            }
            configToml = configToml.replaceAll("(?m)^#", "--");
            configToml = configToml.replaceAll("\r", "");
            SFM.LOGGER.info("Sending config to player: {}", (Object)player.getName().getString());
            SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundServerConfigCommandPacket(configToml, msg.requestingEditMode()));
        }

        @Override
        public Class<ServerboundServerConfigRequestPacket> getPacketClass() {
            return ServerboundServerConfigRequestPacket.class;
        }
    }
}

