/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;

public class SFMTranslationUtils {
    public static final int MAX_TRANSLATION_ELEMENT_LENGTH = 10240;

    public static TranslatableContents deserializeTranslation(CompoundTag tag) {
        String key = tag.getString("key");
        Object[] args = tag.getList("args", 8).stream().map(StringTag.class::cast).map(StringTag::getAsString).toArray();
        return SFMTranslationUtils.getTranslatableContents(key, args);
    }

    public static CompoundTag serializeTranslation(TranslatableContents contents) {
        CompoundTag tag = new CompoundTag();
        tag.putString("key", contents.getKey());
        ListTag args = new ListTag();
        for (Object arg : contents.getArgs()) {
            args.add((Object)StringTag.valueOf((String)arg.toString()));
        }
        tag.put("args", (Tag)args);
        return tag;
    }

    public static void encodeTranslation(TranslatableContents contents, FriendlyByteBuf buf) {
        buf.writeUtf(contents.getKey(), 10240);
        buf.writeVarInt(contents.getArgs().length);
        for (Object arg : contents.getArgs()) {
            buf.writeUtf(String.valueOf(arg), 10240);
        }
    }

    public static TranslatableContents decodeTranslation(FriendlyByteBuf buf) {
        String key = buf.readUtf(10240);
        int argCount = buf.readVarInt();
        Object[] args = new Object[argCount];
        for (int i = 0; i < argCount; ++i) {
            args[i] = buf.readUtf(10240);
        }
        return SFMTranslationUtils.getTranslatableContents(key, args);
    }

    @MCVersionDependentBehaviour
    public static TranslatableContents getTranslatableContents(String key, Object ... args) {
        return new TranslatableContents(key, null, args);
    }

    public static TranslatableContents getTranslatableContents(String key) {
        return SFMTranslationUtils.getTranslatableContents(key, new Object[0]);
    }
}

