/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.program_builder;

import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.program_builder.ProgramMetadata;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.antlr.v4.runtime.Token;
import org.jetbrains.annotations.Nullable;

public record ProgramBuildResult(@Nullable Program program, ProgramMetadata metadata) {
    public boolean isBuildSuccessful() {
        return this.program != null && this.metadata.errors().isEmpty();
    }

    public ProgramBuildResult caseSuccess(BiConsumer<Program, ProgramMetadata> callback) {
        if (this.isBuildSuccessful()) {
            callback.accept(this.program(), this.metadata());
        }
        return this;
    }

    public ProgramBuildResult caseFailure(Consumer<ProgramBuildResult> callback) {
        if (!this.isBuildSuccessful()) {
            callback.accept(this);
        }
        return this;
    }

    @Nullable
    public Token getTokenAtCursorPosition(int cursorPos) {
        for (Token token : this.metadata().tokens().getTokens()) {
            if (token.getStartIndex() > cursorPos || token.getStopIndex() + 1 < cursorPos) continue;
            return token;
        }
        return null;
    }

    public String getWordAtCursorPosition(int cursorPos) {
        char c;
        StringBuilder word = new StringBuilder();
        for (int i = cursorPos - 1; i >= 0 && !Character.isWhitespace(c = this.metadata().programString().charAt(i)); --i) {
            word.insert(0, c);
        }
        return word.toString();
    }
}

