/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import org.simmetrics.StringDistance;
import org.simmetrics.StringMetric;

public final class Jaro
implements StringMetric,
StringDistance {
    @Override
    public float distance(String a, String b) {
        return 1.0f - this.compare(a, b);
    }

    @Override
    public float compare(String a, String b) {
        int commonCharacters;
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        int halfLength = Math.max(0, Math.max(a.length(), b.length()) / 2 - 1);
        char[] charsA = a.toCharArray();
        char[] charsB = b.toCharArray();
        int[] commonA = Jaro.getCommonCharacters(charsA, charsB, halfLength);
        int[] commonB = Jaro.getCommonCharacters(charsB, charsA, halfLength);
        float transpositions = 0.0f;
        int length = commonA.length;
        for (commonCharacters = 0; commonCharacters < length && commonA[commonCharacters] > -1; ++commonCharacters) {
            if (commonA[commonCharacters] == commonB[commonCharacters]) continue;
            transpositions += 1.0f;
        }
        if (commonCharacters == 0) {
            return 0.0f;
        }
        float aCommonRatio = (float)commonCharacters / (float)a.length();
        float bCommonRatio = (float)commonCharacters / (float)b.length();
        float transpositionRatio = ((float)commonCharacters - transpositions / 2.0f) / (float)commonCharacters;
        return (aCommonRatio + bCommonRatio + transpositionRatio) / 3.0f;
    }

    private static int[] getCommonCharacters(char[] charsA, char[] charsB, int separation) {
        int[] common = new int[Math.min(charsA.length, charsB.length)];
        boolean[] matched = new boolean[charsB.length];
        int commonIndex = 0;
        int length = charsA.length;
        for (int i = 0; i < length; ++i) {
            int character = charsA[i];
            int index = Jaro.indexOf((char)character, charsB, i - separation, i + separation + 1, matched);
            if (index <= -1) continue;
            common[commonIndex++] = character;
            matched[index] = true;
        }
        if (commonIndex < common.length) {
            common[commonIndex] = -1;
        }
        return common;
    }

    private static int indexOf(char character, char[] buffer, int fromIndex, int toIndex, boolean[] matched) {
        int length = Math.min(toIndex, buffer.length);
        for (int j = Math.max(0, fromIndex); j < length; ++j) {
            if (buffer[j] != character || matched[j]) continue;
            return j;
        }
        return -1;
    }

    public String toString() {
        return "Jaro";
    }
}

