/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capability;

import ca.teamdman.sfm.common.capability.IRedstoneSignalStorage;
import ca.teamdman.sfm.common.capability.RedstoneSignalStorage;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class RedstoneSignalCapabilityProvider
implements SFMBlockCapabilityProvider<IRedstoneSignalStorage>,
IBlockCapabilityProvider<IRedstoneSignalStorage, Direction> {
    @Override
    public boolean matchesCapabilityKind(SFMBlockCapabilityKind<?> capabilityKind) {
        return capabilityKind.equals(SFMWellKnownCapabilities.REDSTONE_HANDLER);
    }

    @Override
    public SFMBlockCapabilityResult<IRedstoneSignalStorage> getCapability(SFMBlockCapabilityKind<IRedstoneSignalStorage> capabilityKind, LevelAccessor level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        try {
            int signal = state.getSignal((BlockGetter)level, pos, direction);
            return SFMBlockCapabilityResult.of(new RedstoneSignalStorage(signal, 15));
        }
        catch (Throwable t) {
            return SFMBlockCapabilityResult.empty();
        }
    }

    @Nullable
    public IRedstoneSignalStorage getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction context) {
        try {
            int signal = state.getSignal((BlockGetter)level, pos, context);
            return new RedstoneSignalStorage(signal, 15);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

