/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.CapabilityCache;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.registry.SFMCapabilityProviderMappers;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableNetwork {
    protected final Level LEVEL;
    protected final LongSet CABLE_POSITIONS = new LongOpenHashSet();
    protected final CapabilityCache CAPABILITY_CACHE = new CapabilityCache();

    public CableNetwork(Level level) {
        this.LEVEL = level;
    }

    public static boolean isCable(@Nullable Level world, @NotStored BlockPos cablePos) {
        if (world == null) {
            return false;
        }
        return world.m_8055_(cablePos).m_60734_() instanceof ICableBlock;
    }

    public void rebuildNetwork(@NotStored BlockPos start) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_CACHE.clear();
        CableNetwork.discoverCables(this.getLevel(), start).forEach(this::addCable);
    }

    public void rebuildNetworkFromCache(@NotStored BlockPos start, CableNetwork other) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_CACHE.clear();
        List cables = SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.m_122190_((Vec3i)current).m_122173_(d);
                if (!other.containsCablePosition((BlockPos)target)) continue;
                next.accept(target.m_7949_());
            }
        }, start).toList();
        for (BlockPos cablePos : cables) {
            this.CABLE_POSITIONS.add(cablePos.m_121878_());
        }
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        LongOpenHashSet seenCapabilityPositions = new LongOpenHashSet();
        for (BlockPos cablePos : cables) {
            for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.m_122190_((Vec3i)cablePos).m_122173_(direction);
                boolean firstVisit = seenCapabilityPositions.add(target.m_121878_());
                if (!firstVisit) continue;
                this.CAPABILITY_CACHE.overwriteFromOther((BlockPos)target, other.CAPABILITY_CACHE);
            }
        }
    }

    public static Stream<BlockPos> discoverCables(Level level, @NotStored BlockPos startPos) {
        return SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.m_122190_((Vec3i)current).m_122173_(d);
                if (!CableNetwork.isCable(level, (BlockPos)target)) continue;
                next.accept(target.m_7949_());
            }
        }, startPos);
    }

    public void addCable(@NotStored BlockPos pos) {
        this.CABLE_POSITIONS.add(pos.m_121878_());
    }

    public Level getLevel() {
        return this.LEVEL;
    }

    public String toString() {
        return "CableNetwork{level=" + this.getLevel().m_46472_().m_135782_() + ", #cables=" + this.getCableCount() + ", #cache=" + this.CAPABILITY_CACHE.size() + "}";
    }

    public boolean isAdjacentToCable(@NotStored BlockPos pos) {
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.m_122190_((Vec3i)pos).m_122173_(direction);
            if (!this.containsCablePosition((BlockPos)target)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCablePosition(@NotStored BlockPos pos) {
        return this.CABLE_POSITIONS.contains(pos.m_121878_());
    }

    @NotNull
    public <CAP> LazyOptional<CAP> getCapability(Capability<CAP> capKind, @NotStored BlockPos pos, @Nullable Direction direction, TranslatableLogger logger) {
        LazyOptional<CAP> found = this.CAPABILITY_CACHE.getCapability(pos, capKind, direction);
        if (found != null) {
            if (found.isPresent()) {
                logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_HIT.get(pos, capKind.getName(), direction)));
                return found;
            }
            logger.error(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_HIT_INVALID.get(pos, capKind.getName(), direction)));
        } else {
            logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_MISS.get(pos, capKind.getName(), direction)));
        }
        if (!this.isAdjacentToCable(pos)) {
            logger.warn(x -> x.accept(LocalizationKeys.LOGS_MISSING_ADJACENT_CABLE.get(pos)));
            return LazyOptional.empty();
        }
        ICapabilityProvider capabilityProvider = SFMCapabilityProviderMappers.discoverCapabilityProvider(this.LEVEL, pos.m_7949_());
        if (capabilityProvider != null) {
            LazyOptional cap = capabilityProvider.getCapability(capKind, direction);
            if (cap.isPresent()) {
                this.CAPABILITY_CACHE.putCapability(pos, capKind, direction, cap);
                cap.addListener(x -> this.CAPABILITY_CACHE.remove(pos, capKind, direction));
            } else {
                logger.warn(x -> x.accept(LocalizationKeys.LOGS_EMPTY_CAPABILITY.get(pos, capKind.getName(), direction)));
            }
            return cap;
        }
        logger.warn(x -> x.accept(LocalizationKeys.LOGS_MISSING_CAPABILITY_PROVIDER.get(pos, capKind.getName(), direction)));
        return LazyOptional.empty();
    }

    public int getCableCount() {
        return this.CABLE_POSITIONS.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.CABLE_POSITIONS.addAll((LongCollection)other.CABLE_POSITIONS);
        this.CAPABILITY_CACHE.putAll(other.CAPABILITY_CACHE);
    }

    public boolean isEmpty() {
        return this.CABLE_POSITIONS.isEmpty();
    }

    public Stream<BlockPos> getCablePositions() {
        return this.CABLE_POSITIONS.longStream().mapToObj(BlockPos::m_122022_);
    }

    public LongSet getCablePositionsRaw() {
        return this.CABLE_POSITIONS;
    }

    public Stream<BlockPos> getCapabilityProviderPositions() {
        return this.CAPABILITY_CACHE.getPositions();
    }

    public void bustCacheForChunk(ChunkAccess chunkAccess) {
        this.CAPABILITY_CACHE.bustCacheForChunk(chunkAccess);
    }

    protected List<CableNetwork> withoutCable(@NotStored BlockPos cablePos) {
        this.CABLE_POSITIONS.remove(cablePos.m_121878_());
        ArrayList<CableNetwork> branches = new ArrayList<CableNetwork>();
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.m_122190_((Vec3i)cablePos).m_122173_(direction);
            if (!this.containsCablePosition((BlockPos)target) || branches.stream().anyMatch(n -> n.containsCablePosition((BlockPos)target))) continue;
            CableNetwork branchNetwork = new CableNetwork(this.getLevel());
            branchNetwork.rebuildNetworkFromCache((BlockPos)target, this);
            branches.add(branchNetwork);
        }
        return branches;
    }
}

