/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.diagnostics;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.diagnostics.SFMClientDiagnostics;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.forge.ForgeVersion;

public class SFMDiagnostics {
    public static String getDiagnosticsSummary(ItemStack diskStack) {
        if (SFMEnvironmentUtils.isClient()) {
            return SFMClientDiagnostics.getDiagnosticsSummary(diskStack);
        }
        StringBuilder content = new StringBuilder();
        try {
            List<TranslatableContents> warnings;
            content.append("-- Diagnostic info --\n");
            content.append("-- Program:\n").append(DiskItem.getProgram(diskStack)).append("\n\n");
            content.append("-- DateTime: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm.ss").format(new Date())).append('\n');
            content.append("-- Game Version: ").append("Minecraft ").append(SharedConstants.m_183709_().getName()).append('\n');
            content.append("-- Forge Version: ").append(ForgeVersion.getVersion()).append('\n');
            ModList.get().getModContainerById("sfm").ifPresent(mod -> content.append("-- SFM Version: ").append(mod.getModInfo().getVersion()).append('\n'));
            List<TranslatableContents> errors = DiskItem.getErrors(diskStack);
            if (!errors.isEmpty()) {
                content.append("\n-- Errors\n");
                for (TranslatableContents error : errors) {
                    content.append("-- * ").append(error.toString()).append("\n");
                }
            }
            if (!(warnings = DiskItem.getWarnings(diskStack)).isEmpty()) {
                content.append("\n-- Warnings\n");
                for (TranslatableContents warning : warnings) {
                    content.append("-- * ").append(warning.toString()).append("\n");
                }
            }
            LabelPositionHolder labels = LabelPositionHolder.from(diskStack);
            content.append("\n-- Labels\n").append(labels.toDebugString());
        }
        catch (Throwable t) {
            SFM.LOGGER.error("Failed gathering diagnostic info, returning partial results. Error: ", t);
        }
        return content.toString();
    }
}

