/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ClientKeyHelpers;
import ca.teamdman.sfm.client.ClientLabelGunWarningHelper;
import ca.teamdman.sfm.client.handler.LabelGunKeyMappingHandler;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.SFMItemUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LabelGunItem
extends Item {
    public LabelGunItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(SFMItems.TAB));
    }

    public static void setActiveLabel(ItemStack stack, @Nullable String label) {
        if (label == null || label.isEmpty()) {
            LabelGunItem.clearActiveLabel(stack);
        } else {
            LabelPositionHolder.from(stack).addReferencedLabel(label).save(stack);
            stack.m_41784_().m_128359_("sfm:active_label", label);
        }
    }

    public static void clearActiveLabel(ItemStack gun) {
        gun.m_41784_().m_128473_("sfm:active_label");
    }

    public static String getActiveLabel(ItemStack stack) {
        return !stack.m_41782_() ? "" : stack.m_41783_().m_128461_("sfm:active_label");
    }

    public static String getNextLabel(ItemStack gun, int change) {
        List labels = LabelPositionHolder.from(gun).labels().keySet().stream().sorted(Comparator.naturalOrder()).toList();
        if (labels.isEmpty()) {
            return "";
        }
        String currentLabel = LabelGunItem.getActiveLabel(gun);
        int currentLabelIndex = 0;
        for (int i = 0; i < labels.size(); ++i) {
            if (!((String)labels.get(i)).equals(currentLabel)) continue;
            currentLabelIndex = i;
            break;
        }
        int nextLabelIndex = currentLabelIndex + change;
        nextLabelIndex = (nextLabelIndex % labels.size() + labels.size()) % labels.size();
        return (String)labels.get(nextLabelIndex);
    }

    public static LabelGunViewMode getViewMode(ItemStack stack) {
        int ordinal = stack.m_41784_().m_128451_("sfm:label_gun_view_mode");
        if (ordinal < 0 || ordinal >= LabelGunViewMode.values().length) {
            return LabelGunViewMode.SHOW_ALL;
        }
        return LabelGunViewMode.values()[ordinal];
    }

    public static void setViewMode(ItemStack stack, LabelGunViewMode mode) {
        stack.m_41784_().m_128405_("sfm:label_gun_view_mode", mode.ordinal());
    }

    public static void cycleViewMode(ItemStack stack) {
        LabelGunViewMode current = LabelGunItem.getViewMode(stack);
        int nextOrdinal = (current.ordinal() + 1) % LabelGunViewMode.values().length;
        LabelGunItem.setViewMode(stack, LabelGunViewMode.values()[nextOrdinal]);
    }

    public InteractionResult onItemUseFirst(ItemStack gun, UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (level.f_46443_ && player != null) {
            boolean pickBlock = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_PICK_BLOCK_MODIFIER_KEY);
            boolean contiguous = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_CONTIGUOUS_MODIFIER_KEY);
            boolean clear = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_CLEAR_MODIFIER_KEY);
            boolean pull = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_PULL_MODIFIER_KEY);
            boolean targetManager = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_TARGET_MANAGER_MODIFIER_KEY);
            ServerboundLabelGunUsePacket msg = new ServerboundLabelGunUsePacket(ctx.m_43724_(), ctx.m_8083_(), contiguous, pickBlock, clear, pull, targetManager);
            ClientLabelGunWarningHelper.sendLabelGunUsePacketFromClientWithConfirmationIfNecessary(msg, player);
            if (pickBlock) {
                LabelGunKeyMappingHandler.setExternalDebounce();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        if (SFMItemUtils.isClientAndMoreInfoKeyPressed()) {
            Options options = Minecraft.m_91087_().f_91066_;
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_1.getComponent(options.f_92095_.m_90863_().m_6879_().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_2.getComponent(options.f_92095_.m_90863_().m_6879_().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_3.getComponent(Component.m_237113_((String)"Control").m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_4.getComponent(options.f_92097_.m_90863_().m_6879_().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_5.getComponent(((KeyMapping)SFMKeyMappings.CYCLE_LABEL_VIEW_KEY.get()).m_90863_().m_6879_().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
        } else {
            SFMItemUtils.appendMoreInfoKeyReminderTextIfOnClient(lines);
        }
        lines.addAll(LabelPositionHolder.from(stack).asHoverText());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            SFMScreenChangeHelpers.showLabelGunScreen(stack, hand);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public Component m_7626_(ItemStack stack) {
        String name = LabelGunItem.getActiveLabel(stack);
        if (name.isEmpty()) {
            return super.m_7626_(stack);
        }
        return LocalizationKeys.LABEL_GUN_ITEM_NAME_WITH_LABEL.getComponent(name).m_130940_(ChatFormatting.AQUA);
    }

    public static void clearAll(ItemStack stack) {
        LabelPositionHolder.clear(stack);
        LabelGunItem.setActiveLabel(stack, null);
    }

    public static enum LabelGunViewMode {
        SHOW_ALL,
        SHOW_ONLY_ACTIVE_LABEL_AND_TARGETED_BLOCK,
        SHOW_ONLY_TARGETED_BLOCK;

    }
}

