/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.logging;

import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.message.Message;

@Plugin(name="TranslatableAppender", category="Core", elementType="appender", printObject=true)
public class TranslatableAppender
extends AbstractAppender {
    public final LinkedList<TranslatableLogEvent> contents = new LinkedList();

    protected TranslatableAppender(String name, Layout<? extends Serializable> layout) {
        super(name, null, layout, true, null);
    }

    @PluginFactory
    public static TranslatableAppender createAppender(@PluginBuilderAttribute(value="name") String name) {
        PatternLayout layout = PatternLayout.createDefaultLayout();
        return new TranslatableAppender(name, (Layout<? extends Serializable>)layout);
    }

    public void append(LogEvent event) {
        MutableInstant instant = new MutableInstant();
        instant.initFrom(event.getInstant());
        Level level = event.getLevel();
        Message message = event.getMessage();
        Object[] params = message.getParameters();
        String[] stringParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            stringParams[i] = Objects.toString(params[i]);
        }
        TranslatableContents content = new TranslatableContents(message.getFormat(), (Object[])stringParams);
        this.contents.add(new TranslatableLogEvent(level, (Instant)instant, content));
    }
}

