/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.RegexCache;
import ca.teamdman.sfml.ast.ASTNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;

public class TagMatcher
implements Predicate<Object>,
ASTNode {
    public final String namespacePattern;
    public final List<String> pathElementPatterns;
    private final Predicate<String> namespacePredicate;
    private final List<Predicate<String>> pathElementPredicates;

    public String toString() {
        return this.namespacePattern + ":" + String.join((CharSequence)"/", this.pathElementPatterns);
    }

    private TagMatcher(String namespacePattern, Collection<String> pathElementPatterns) {
        this.namespacePattern = namespacePattern;
        this.pathElementPatterns = List.copyOf(pathElementPatterns);
        this.namespacePredicate = RegexCache.buildPredicate(namespacePattern);
        this.pathElementPredicates = this.pathElementPatterns.stream().map(RegexCache::buildPredicate).toList();
    }

    public static TagMatcher fromNamespaceAndPath(String namespace, Collection<String> path) {
        return new TagMatcher(namespace, new ArrayList<String>(path));
    }

    public static TagMatcher fromPath(Collection<String> pathElements) {
        return new TagMatcher(".*", pathElements);
    }

    @Override
    public boolean test(Object o) {
        if (o instanceof ResourceLocation) {
            ResourceLocation resourceLocation = (ResourceLocation)o;
            return this.testResourceLocation(resourceLocation);
        }
        if (o instanceof String) {
            String string = (String)o;
            return this.testString(string);
        }
        return false;
    }

    public boolean testResourceLocation(ResourceLocation resourceLocation) {
        return this.testPath(resourceLocation.m_135827_(), resourceLocation.m_135815_().split("/"));
    }

    public boolean testString(String string) {
        String[] chunks = string.split(":");
        if (chunks.length == 0) {
            return false;
        }
        if (chunks.length == 1) {
            return this.testPath("", string.split("/"));
        }
        return this.testPath(chunks[0], chunks[1].split("/"));
    }

    private boolean testPath(String checkNamespace, String[] checkPathElements) {
        if (checkPathElements.length < this.pathElementPatterns.size()) {
            return false;
        }
        if (!this.namespacePredicate.test(checkNamespace)) {
            return false;
        }
        for (int i = 0; i < checkPathElements.length; ++i) {
            if (i >= this.pathElementPatterns.size()) {
                return false;
            }
            if (this.pathElementPatterns.get(i).equals(".*.*")) {
                return true;
            }
            if (this.pathElementPredicates.get(i).test(checkPathElements[i])) continue;
            return false;
        }
        return true;
    }
}

