/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.intellisense;

import ca.teamdman.langs.SFMLParser;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import ca.teamdman.sfml.ext_antlr4c3.CodeCompletionCore;
import ca.teamdman.sfml.intellisense.IntellisenseAction;
import ca.teamdman.sfml.intellisense.IntellisenseContext;
import ca.teamdman.sfml.intellisense.SuggestedLabelIntellisenseAction;
import ca.teamdman.sfml.intellisense.SuggestedResourceIntellisenseAction;
import ca.teamdman.sfml.intellisense.SuggestedTokensIntellisenseAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.jetbrains.annotations.Nullable;

public class SFMLIntellisense {
    public static List<IntellisenseAction> getSuggestions(IntellisenseContext context) {
        ArrayList<IntellisenseAction> rtn = new ArrayList<IntellisenseAction>();
        if (context.intellisenseLevel().isDisabled()) {
            return rtn;
        }
        SFMLParser parser = context.programBuildResult().metadata().parser();
        Set<Integer> preferredRules = Set.of(Integer.valueOf(17), Integer.valueOf(34));
        Set<Integer> ignoredTokens = Set.of(Integer.valueOf(73), Integer.valueOf(-1));
        CodeCompletionCore core = new CodeCompletionCore(parser, preferredRules, ignoredTokens);
        @Nullable Token caretToken = context.programBuildResult().getTokenAtCursorPosition(context.cursorPosition());
        if (caretToken == null) {
            return new ArrayList<IntellisenseAction>();
        }
        int caretTokenIndex = caretToken.getTokenIndex();
        CodeCompletionCore.CandidatesCollection candidates = core.collectCandidates(caretTokenIndex, null);
        Vocabulary vocabulary = parser.getVocabulary();
        candidates.rules.forEach((head, tail) -> {
            switch (head) {
                case 17: {
                    if (!SFMEnvironmentUtils.isGameLoaded() || !context.intellisenseLevel().isResourceIntellisenseEnabled()) break;
                    for (ResourceType resourceType : SFMResourceTypes.registry().getValues()) {
                        SFMLIntellisense.gatherIntellisenseActions(context, resourceType, rtn::add);
                    }
                    break;
                }
                case 34: {
                    rtn.add(new SuggestedTokensIntellisenseAction(71, new ArrayList<Integer>(), vocabulary));
                    context.labelPositionHolder().labels().forEach((key, value) -> rtn.add(new SuggestedLabelIntellisenseAction((String)key, value.size())));
                }
            }
        });
        for (Map.Entry<Integer, List<Integer>> entry : candidates.tokens.entrySet()) {
            rtn.add(new SuggestedTokensIntellisenseAction(entry.getKey(), entry.getValue(), vocabulary));
        }
        return rtn;
    }

    private static <STACK, ITEM, CAP> void gatherIntellisenseActions(IntellisenseContext ignoredContext, ResourceType<STACK, ITEM, CAP> resourceType, Consumer<IntellisenseAction> results) {
        for (ITEM item : resourceType.getItems()) {
            SuggestedResourceIntellisenseAction<STACK, ITEM, CAP> suggestion = new SuggestedResourceIntellisenseAction<STACK, ITEM, CAP>(resourceType, item);
            results.accept(suggestion);
        }
    }
}

